<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\Filesystem;

// Інтерфейс для роботи з директоріями
interface DirectoryInterface
{
    // Створити директорію
    public function create(string $path, int $mode = 0755, bool $recursive = false): bool;

    // Видалити директорію
    public function delete(string $path, bool $preserve = false): bool;

    // Перевірити існування директорії
    public function exists(string $path): bool;

    // Отримати всі файли в директорії
    public function files(string $path, bool $hidden = false): array;

    // Отримати всі директорії в директорії
    public function directories(string $path): array;

    // Отримати всі елементи в директорії
    public function all(string $path): array;

    // Копіювати директорію
    public function copy(string $from, string $to): bool;

    // Перемістити директорію
    public function move(string $from, string $to): bool;
}
