<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\Filesystem;

// Інтерфейс для роботи з архівами
interface ArchiveInterface
{
    // Відкрити архів
    public function open(string $filePath, int $flags = 1): self;

    // Закрити архів
    public function close(): bool;

    // Додати файл до архіву
    public function addFile(string $filePath, ?string $localName = null): bool;

    // Додати директорію до архіву
    public function addDirectory(string $directoryPath): bool;

    // Розпакувати архів
    public function extractTo(string $destinationPath): bool;

    // Отримати список файлів
    public function listFiles(): array;

    // Отримати файл з архіву
    public function getFromName(string $fileName): string|false;

    // Видалити файл з архіву
    public function deleteName(string $fileName): bool;
}
