<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\Domain\User;

use Flowaxy\Domain\User\Entities\User;

// Інтерфейс репозиторію користувачів
interface UserRepositoryInterface
{
    // Знайти користувача за ID
    public function findById(int $id): ?User;

    // Знайти користувача за email
    public function findByEmail(string $email): ?User;

    // Створити користувача
    public function create(array $data): User;

    // Оновити користувача
    public function update(int $id, array $data): bool;

    // Видалити користувача
    public function delete(int $id): bool;

    // Знайти всіх користувачів
    public function findAll(array $criteria = []): array;
}
