<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\Domain\User;

use Flowaxy\Domain\User\Entities\Role;

// Інтерфейс репозиторію ролей
interface RoleRepositoryInterface
{
    // Знайти роль за ID
    public function findById(int $id): ?Role;

    // Знайти роль за ім'ям
    public function findByName(string $name): ?Role;

    // Створити роль
    public function create(array $data): Role;

    // Оновити роль
    public function update(int $id, array $data): bool;

    // Видалити роль
    public function delete(int $id): bool;

    // Знайти всі ролі
    public function findAll(): array;

    // Отримати ролі користувача
    public function getRolesForUser(int $userId): array;

    // Отримати дозволи користувача
    public function getPermissionsForUser(int $userId): array;

    // Перевірити, чи має користувач роль
    public function userHasRole(int $userId, string $roleSlug): bool;

    // Перевірити, чи має користувач дозвіл
    public function userHasPermission(int $userId, string $permission): bool;

    // Призначити роль користувачу
    public function assignRole(int $userId, int $roleId): bool;

    // Видалити роль у користувача
    public function removeRole(int $userId, int $roleId): bool;
}
