<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\Domain\User;

use Flowaxy\Domain\User\Entities\AdminUser;

// Інтерфейс репозиторію адмін-користувачів
interface AdminUserRepositoryInterface
{
    // Знайти адмін-користувача за ID
    public function findById(int $id): ?AdminUser;

    // Знайти адмін-користувача за email
    public function findByEmail(string $email): ?AdminUser;

    // Знайти адмін-користувача за username
    public function findByUsername(string $username): ?AdminUser;

    // Створити адмін-користувача
    public function create(array $data): AdminUser;

    // Оновити адмін-користувача
    public function update(int $id, array $data): bool;

    // Видалити адмін-користувача
    public function delete(int $id): bool;

    // Знайти всіх адмін-користувачів
    public function findAll(array $criteria = []): array;

    // Оновити сесію користувача
    public function updateSession(int $userId, string $token, string $lastActivity): bool;

    // Очистити сесію користувача
    public function clearSession(int $userId): bool;

    // Позначити користувача як неактивного
    public function markInactive(int $userId): bool;

    // Оновити час останньої активності
    public function updateLastActivity(int $userId, string $timestamp): bool;
}
