<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\Domain\User;

use Flowaxy\Domain\User\Entities\AdminRole;

// Інтерфейс репозиторію адмін-ролей
interface AdminRoleRepositoryInterface
{
    // Знайти адмін-роль за ID
    public function findById(int $id): ?AdminRole;

    // Знайти адмін-роль за ім'ям
    public function findByName(string $name): ?AdminRole;

    // Створити адмін-роль
    public function create(array $data): AdminRole;

    // Оновити адмін-роль
    public function update(int $id, array $data): bool;

    // Видалити адмін-роль
    public function delete(int $id): bool;

    // Знайти всі адмін-ролі
    public function findAll(): array;
}
