<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\Domain\Theme;

// Інтерфейс репозиторію налаштувань тем
interface ThemeSettingsRepositoryInterface
{
    // Отримати налаштування
    public function get(string $themeSlug, string $key, mixed $default = null): mixed;

    // Встановити налаштування
    public function set(string $themeSlug, string $key, mixed $value): bool;

    // Отримати всі налаштування
    public function getAll(string $themeSlug): array;

    // Видалити налаштування
    public function delete(string $themeSlug, string $key): bool;

    // Очистити всі налаштування
    public function clear(string $themeSlug): bool;
}
