<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\Domain\Theme;

use Flowaxy\Domain\Theme\Entities\Theme;

// Інтерфейс репозиторію тем
interface ThemeRepositoryInterface
{
    // Отримати всі теми
    public function all(): array;

    // Знайти тему за slug
    public function find(string $slug): ?Theme;

    // Отримати активну тему
    public function getActive(): ?Theme;

    // Активувати тему
    public function activate(string $slug): bool;
}
