<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\Domain\Plugin;

use Flowaxy\Domain\Plugin\Entities\Plugin;

// Інтерфейс репозиторію плагінів
interface PluginRepositoryInterface
{
    // Отримати всі плагіни
    public function all(): array;

    // Знайти плагін за slug
    public function find(string $slug): ?Plugin;

    // Встановити плагін
    public function install(Plugin $plugin): bool;

    // Видалити плагін
    public function uninstall(string $slug): bool;

    // Активувати плагін
    public function activate(string $slug): bool;

    // Деактивувати плагін
    public function deactivate(string $slug): bool;

    // Отримати налаштування плагіна
    public function getSettings(string $slug): array;

    // Встановити налаштування плагіна
    public function setSetting(string $slug, string $key, mixed $value): bool;
}
