<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\Domain\Plugin;

// Інтерфейс життєвого циклу плагіна
interface PluginLifecycleInterface
{
    // Встановити плагін
    public function install(string $pluginSlug): bool;

    // Видалити плагін
    public function uninstall(string $pluginSlug): bool;

    // Активувати плагін
    public function activate(string $pluginSlug): bool;

    // Деактивувати плагін
    public function deactivate(string $pluginSlug): bool;
}
