<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\Domain\Plugin;

// Інтерфейс файлової системи плагінів
interface PluginFilesystemInterface
{
    // Перевірити існування плагіна
    public function exists(string $pluginSlug): bool;

    // Прочитати файл
    public function read(string $pluginSlug, string $path): string|false;

    // Записати файл
    public function write(string $pluginSlug, string $path, string $content): bool;

    // Видалити файл або плагін
    public function delete(string $pluginSlug, string $path = ''): bool;

    // Отримати список файлів
    public function list(string $pluginSlug, string $path = ''): array;

    // Отримати шлях до файлу
    public function getPath(string $pluginSlug, string $path = ''): string;

    // Прочитати конфігурацію плагіна
    public function readConfig(string $pluginSlug): ?array;

    // Запустити міграції плагіна
    public function runMigrations(string $pluginSlug): void;
}
