<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\Domain\Plugin;

// Інтерфейс кешу плагінів
interface PluginCacheInterface
{
    // Отримати значення з кешу
    public function get(string $pluginSlug, string $key, mixed $default = null): mixed;

    // Встановити значення в кеш
    public function set(string $pluginSlug, string $key, mixed $value, ?int $ttl = null): bool;

    // Видалити значення з кешу
    public function delete(string $pluginSlug, string $key): bool;

    // Очистити кеш плагіна
    public function clear(string $pluginSlug): bool;

    // Перевірити наявність ключа
    public function has(string $pluginSlug, string $key): bool;

    // Після встановлення плагіна
    public function afterInstall(string $pluginSlug): void;

    // Після активації плагіна
    public function afterActivate(string $pluginSlug): void;

    // Після деактивації плагіна
    public function afterDeactivate(string $pluginSlug): void;

    // Після видалення плагіна
    public function afterUninstall(string $pluginSlug): void;
}
