<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\Domain\Content;

use Flowaxy\Domain\Content\Entities\Post;
use Flowaxy\Domain\Content\ValueObjects\ContentId;

// Інтерфейс репозиторію контенту
interface ContentRepositoryInterface
{
    // Знайти контент за ID
    public function findById(ContentId $id): ?Post;

    // Створити контент
    public function create(array $data): Post;

    // Оновити контент
    public function update(ContentId $id, array $data): bool;

    // Видалити контент
    public function delete(ContentId $id): bool;

    // Знайти всі записи
    public function findAll(array $criteria = []): array;
}
