<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\Database;

// Інтерфейс для QueryBuilder
interface QueryBuilderInterface
{
    // Вибірка колонок
    public function select(string|array $columns = '*'): self;

    // Вказати таблицю
    public function from(string $table, ?string $alias = null): self;

    // Додати JOIN
    public function join(string $table, string $first, string $operator, string $second, string $type = 'INNER'): self;

    // Додати умову WHERE
    public function where(string|callable $column, ?string $operator = null, mixed $value = null, string $boolean = 'AND'): self;

    // Додати сортування
    public function orderBy(string $column, string $direction = 'ASC'): self;

    // Додати групування
    public function groupBy(string|array $columns): self;

    // Обмежити кількість результатів
    public function limit(int $limit): self;

    // Встановити зміщення
    public function offset(int $offset): self;

    // Отримати всі записи
    public function get(): array;

    // Отримати перший запис
    public function first(): array|false;

    // Підрахувати кількість записів
    public function count(): int;
}
