<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\Database;

use PDO;
use PDOStatement;

// Інтерфейс для роботи з базою даних
interface DatabaseInterface
{
    // Отримати підключення до БД
    public function getConnection(): PDO;

    // Виконати запит
    public function query(string $query, array $params = [], bool $logQuery = true): PDOStatement;

    // Отримати один рядок
    public function getRow(string $query, array $params = []): array|false;

    // Отримати всі рядки
    public function getAll(string $query, array $params = []): array;

    // Отримати одне значення
    public function getValue(string $query, array $params = []): mixed;

    // Вставити запис
    public function insert(string $query, array $params = []): int|false;

    // Виконати запит
    public function execute(string $query, array $params = []): int;

    // Виконати транзакцію
    public function transaction(callable $callback);

    // Екранувати рядок
    public function escape(string $string): string;

    // Перевірити доступність БД
    public function isAvailable(): bool;

    // Перевірити існування бази даних
    public function databaseExists(): bool;

    // Перевірити з'єднання
    public function ping(): bool;

    // Роз'єднатися з БД
    public function disconnect(): void;

    // Отримати статистику
    public function getStats(): array;

    // Отримати список запитів
    public function getQueryList(): array;

    // Отримати помилки запитів
    public function getQueryErrors(): array;

    // Встановити поріг повільних запитів
    public function setSlowQueryThreshold(float $seconds): void;

    // Очистити статистику
    public function clearStats(): void;
}
