<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\Config;

// Інтерфейс для завантажувачів конфігурації
interface ConfigLoaderInterface
{
    // Завантажити конфігурацію з файлу
    public function load(string $path): array|false;

    // Зберегти конфігурацію у файл
    public function save(string $path, array $data): bool;

    // Перевірити, чи підтримується формат
    public function supports(string $extension): bool;
}
