<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\Config;

// Інтерфейс для конфігурації
interface ConfigInterface
{
    // Отримати значення конфігурації
    public function get(string $key, mixed $default = null): mixed;

    // Встановити значення конфігурації
    public function set(string $key, mixed $value): void;

    // Перевірити наявність ключа
    public function has(string $key): bool;

    // Отримати всі значення конфігурації
    public function all(): array;

    // Видалити ключ з конфігурації
    public function forget(string $key): void;
}
