<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\Compilers;

// Інтерфейс для компіляторів
interface CompilerInterface
{
    // Компіляція вихідного файлу в цільовий
    public function compile(string $source, string $destination): bool;

    // Перевірка необхідності компіляції
    public function needsCompilation(string $source, string $destination): bool;

    // Отримати підтримувані розширення файлів
    public function getSupportedExtensions(): array;
}
