<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\Cache;

// Інтерфейс для кешу
interface CacheInterface
{
    // Отримати значення з кешу
    public function get(string $key, mixed $default = null): mixed;

    // Встановити значення в кеш
    public function set(string $key, mixed $value, ?int $ttl = null): bool;

    // Видалити значення з кешу
    public function delete(string $key): bool;

    // Очистити весь кеш
    public function clear(): bool;

    // Перевірити наявність ключа
    public function has(string $key): bool;

    // Отримати та видалити значення
    public function pull(string $key, mixed $default = null): mixed;

    // Збільшити значення
    public function increment(string $key, int $value = 1): int;

    // Зменшити значення
    public function decrement(string $key, int $value = 1): int;

    // Отримати або встановити значення
    public function remember(string $key, callable $callback, ?int $ttl = null): mixed;
}
