<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\Cache;

// Інтерфейс драйвера кешу
interface CacheDriverInterface
{
    // Отримання значення з кешу
    public function get(string $key, mixed $default = null): mixed;

    // Збереження значення в кеш
    public function set(string $key, mixed $value, ?int $ttl = null): bool;

    // Видалення значення з кешу
    public function delete(string $key): bool;

    // Перевірка наявності ключа
    public function has(string $key): bool;

    // Очищення всього кешу
    public function clear(): bool;
}
