<?php

declare(strict_types=1);

namespace Flowaxy\Contracts\Assets;

// Інтерфейс для менеджера ассетів
interface AssetManagerInterface
{
    // Додати CSS ресурс
    public function addCss(string $path, ?string $key = null): mixed;

    // Додати JS ресурс
    public function addJs(string $path, ?string $key = null): mixed;

    // Видалити CSS ресурс
    public function removeCss(string $key): void;

    // Видалити JS ресурс
    public function removeJs(string $key): void;

    // Рендеринг всіх CSS ресурсів
    public function renderCss(): string;

    // Рендеринг всіх JS ресурсів
    public function renderJs(): string;

    // Встановити CDN URL
    public function setCdnUrl(string $url): self;

    // Встановити версію
    public function setVersion(string $version): self;
}
