<?php

declare(strict_types=1);

namespace Flowaxy\Bootstrap;

use Flowaxy\Infrastructure\Security\Session as SessionInstance;
use Flowaxy\Interface\Http\Response;
use Throwable;

use function class_exists;
use function headers_sent;
use function method_exists;

// Инициализатор сессии
final class SessionInitializer
{
    // Инициализация сессии
    public static function initialize(bool $isSecure): void
    {
        if (!class_exists(SessionInstance::class)) {
            return;
        }

        if (!method_exists(SessionInstance::class, 'start')) {
            return;
        }

        try {
            SessionInstance::start([
                'domain' => '',
                'path' => '/',
                'secure' => $isSecure,
                'httponly' => true,
                'samesite' => 'Lax',
            ]);
        } catch (Throwable $e) {
            // Продовжуємо роботу навіть якщо сесію не вдалося ініціалізувати
        }

        // Встановлення security headers
        if (!headers_sent() && class_exists(Response::class) && method_exists(Response::class, 'setSecurityHeaders')) {
            try {
                Response::setSecurityHeaders();
            } catch (Throwable $e) {
                // Продовжуємо роботу навіть якщо security headers не вдалося встановити
            }
        }
    }
}
