<?php

declare(strict_types=1);

namespace Flowaxy\Bootstrap;

use Flowaxy\Core\Routing\RouterManager;
use Flowaxy\Core\System\PathResolver;

use function class_exists;
use function file_exists;
use function is_readable;
use const DS;

// Загрузчик роутера
final class RouterLoader
{
    // Загрузка и запуск роутера
    public static function load(): void
    {
        if (!class_exists(PathResolver::class)) {
            return;
        }

        $flowaxyDir = PathResolver::flowaxy();

        // Завантажуємо RequestFilter та його залежності перед RouterManager
        $sanitizerFile = $flowaxyDir . DS . 'Infrastructure' . DS . 'Security' . DS . 'Validators' . DS . 'Sanitizer.php';
        if (file_exists($sanitizerFile) && is_readable($sanitizerFile)) {
            require_once $sanitizerFile;
        }

        $inputValidatorFile = $flowaxyDir . DS . 'Infrastructure' . DS . 'Security' . DS . 'Validators' . DS . 'InputValidator.php';
        if (file_exists($inputValidatorFile) && is_readable($inputValidatorFile)) {
            require_once $inputValidatorFile;
        }

        // Тепер завантажуємо RequestFilter
        $requestFilterFile = $flowaxyDir . DS . 'Infrastructure' . DS . 'Security' . DS . 'RequestFilter.php';
        if (file_exists($requestFilterFile) && is_readable($requestFilterFile)) {
            require_once $requestFilterFile;
        }

        // Завантажуємо Router перед RouterManager
        $routerClassFile = $flowaxyDir . DS . 'Core' . DS . 'Routing' . DS . 'Router.php';
        if (file_exists($routerClassFile) && is_readable($routerClassFile)) {
            require_once $routerClassFile;
        }

        // Завантажуємо RouterManager
        $routerManagerFile = $flowaxyDir . DS . 'Core' . DS . 'Routing' . DS . 'RouterManager.php';
        if (file_exists($routerManagerFile) && is_readable($routerManagerFile)) {
            require_once $routerManagerFile;
        }

        // Диспатчим роутинг напрямую
        if (class_exists(RouterManager::class)) {
            $routerManager = RouterManager::getInstance();
            $routerManager->dispatch();
        }
    }
}
