<?php

declare(strict_types=1);

namespace Flowaxy\Bootstrap;

use Flowaxy\Core\System\PathResolver;

use function class_exists;
use function file_exists;
use function is_readable;
use function realpath;
use const DS;

// Инициализатор PathResolver
final class PathResolverInitializer
{
    // Инициализация PathResolver (загружается ПЕРВЫМ, до всех других процессов)
    public static function initialize(): void
    {
        // Загружаем PathResolver из flowaxy/Core/System/
        $pathResolverFile = __DIR__ . DS . '..' . DS . 'Core' . DS . 'System' . DS . 'PathResolver.php';
        $pathResolverFile = realpath($pathResolverFile);
        if ($pathResolverFile && file_exists($pathResolverFile)) {
            require_once $pathResolverFile;
        }

        // Завантаження хелпер-функцій для роботи з шляхами
        if (class_exists(PathResolver::class)) {
            $pathHelpersFile = PathResolver::flowaxy() . DS . 'Support' . DS . 'Helpers' . DS . 'PathHelper.php';
            if (file_exists($pathHelpersFile) && is_readable($pathHelpersFile)) {
                require_once $pathHelpersFile;
            }
        }
    }
}
