<?php

declare(strict_types=1);

namespace Flowaxy\Bootstrap;

use Flowaxy\Bootstrap\RolesInitializer;
use Flowaxy\Core\System\MigrationRunner as CoreMigrationRunner;
use Flowaxy\Core\System\PathResolver;
use Flowaxy\Support\Helpers\DatabaseHelper;
use Throwable;

use function class_exists;
use function file_exists;
use function is_dir;
use function is_readable;
use function method_exists;
use const DS;

// Запуск миграций
final class MigrationRunner
{
    // Запуск миграций
    public static function run(bool $isInstalled): void
    {
        if (!$isInstalled) {
            return;
        }

        try {
            $db = DatabaseHelper::getConnection();
            if ($db === null || !class_exists(CoreMigrationRunner::class)) {
                return;
            }

            $flowaxyDir = PathResolver::flowaxy();
            $engineDir = PathResolver::engine();
            $migrationsDir = $flowaxyDir . DS . 'Core' . DS . 'System' . DS . 'migrations';

            if (!is_dir($migrationsDir)) {
                // Fallback для обратной совместимости
                $migrationsDir = $engineDir . DS . 'core' . DS . 'system' . DS . 'migrations';
            }

            if (is_dir($migrationsDir) && is_readable($migrationsDir)) {
                try {
                    $runner = new CoreMigrationRunner($migrationsDir, $db);
                    if ($runner !== null && method_exists($runner, 'run')) {
                        $runner->run();
                    }
                } catch (Throwable $migrationError) {
                    // Игнорируем ошибки миграций
                }
            }
        } catch (Throwable $e) {
            // Игнорируем ошибки подключения к БД
        }

        // Инициализация системы ролей
        try {
            RolesInitializer::initialize();
        } catch (Throwable $e) {
            // Продолжаем работу даже если инициализация ролей не удалась
        }
    }
}
