<?php

declare(strict_types=1);

namespace Flowaxy\Bootstrap;

use Flowaxy\Core\System\Registry\HotReloadManager;

use function register_shutdown_function;
use function strtolower;

// Инициализатор hot reload для dev окружения
final class HotReloadInitializer
{
    // Инициализировать hot reload
    public static function initialize(): ?HotReloadManager
    {
        $env = $_ENV['APP_ENV'] ?? $_SERVER['APP_ENV'] ?? 'production';
        if (strtolower($env) !== 'dev' && strtolower($env) !== 'development') {
            return null;
        }

        $manager = new HotReloadManager(750); // 750ms debounce
        $manager->initialize();

        // Регистрируем проверку при каждом запросе
        register_shutdown_function(function () use ($manager) {
            $manager->checkAndReload();
        });

        return $manager;
    }
}
