<?php

declare(strict_types=1);

namespace Flowaxy\Bootstrap;

use Flowaxy\Core\System\PathResolver;

use function class_exists;
use function file_exists;
use function is_readable;
use const DS;

// Загрузчик функций-хелперов
final class HelperFunctionsLoader
{
    // Загрузка всех функций-хелперов (должен вызываться после PathResolverInitializer::initialize())
    public static function load(): void
    {
        if (!class_exists(PathResolver::class)) {
            return;
        }

        $flowaxyDir = PathResolver::flowaxy();

        // Загружаем PathHelper (функции для путей)
        $pathHelperFile = $flowaxyDir . DS . 'Support' . DS . 'Helpers' . DS . 'PathHelper.php';
        if (file_exists($pathHelperFile) && is_readable($pathHelperFile)) {
            require_once $pathHelperFile;
        }

        // Загружаем ClassLoaderHelper (нужен для SecurityHelper)
        $classLoaderHelperFile = $flowaxyDir . DS . 'Support' . DS . 'Helpers' . DS . 'ClassLoaderHelper.php';
        if (file_exists($classLoaderHelperFile) && is_readable($classLoaderHelperFile)) {
            require_once $classLoaderHelperFile;
        }

        // Загружаем UrlHelper (нужен для AdminHelper)
        $urlHelperFile = $flowaxyDir . DS . 'Support' . DS . 'Helpers' . DS . 'UrlHelper.php';
        if (file_exists($urlHelperFile) && is_readable($urlHelperFile)) {
            require_once $urlHelperFile;
        }

        // Загружаем SecurityHelper (нужен для AdminHelper)
        $securityHelperFile = $flowaxyDir . DS . 'Support' . DS . 'Helpers' . DS . 'SecurityHelper.php';
        if (file_exists($securityHelperFile) && is_readable($securityHelperFile)) {
            require_once $securityHelperFile;
        }

        // Загружаем AdminHelper (функции для админки)
        $adminHelperFile = $flowaxyDir . DS . 'Support' . DS . 'Helpers' . DS . 'AdminHelper.php';
        if (file_exists($adminHelperFile) && is_readable($adminHelperFile)) {
            require_once $adminHelperFile;
        }

        // Загружаем ContentHelper (функции для работы с контентом)
        $contentHelperFile = $flowaxyDir . DS . 'Support' . DS . 'Helpers' . DS . 'ContentHelper.php';
        if (file_exists($contentHelperFile) && is_readable($contentHelperFile)) {
            require_once $contentHelperFile;
        }

        // Загружаем ComponentHelper (функции для компонентов)
        $componentHelperFile = $flowaxyDir . DS . 'Support' . DS . 'Helpers' . DS . 'ComponentHelper.php';
        if (file_exists($componentHelperFile) && is_readable($componentHelperFile)) {
            require_once $componentHelperFile;
        }

        // Загружаем RoleHelper (функции для работы с ролями и правами)
        $roleHelperFile = $flowaxyDir . DS . 'Support' . DS . 'Helpers' . DS . 'RoleHelper.php';
        if (file_exists($roleHelperFile) && is_readable($roleHelperFile)) {
            require_once $roleHelperFile;
        }

        // Загружаем ErrorHelper (глобальные функции для обработки ошибок)
        $errorHelperFile = $flowaxyDir . DS . 'Support' . DS . 'Helpers' . DS . 'ErrorHelper.php';
        if (file_exists($errorHelperFile) && is_readable($errorHelperFile)) {
            require_once $errorHelperFile;
        }

        // Загружаем RouteHelper (функции для регистрации маршрутов плагинами и темами)
        $routeHelperFile = $flowaxyDir . DS . 'Support' . DS . 'Helpers' . DS . 'RouteHelper.php';
        if (file_exists($routeHelperFile) && is_readable($routeHelperFile)) {
            require_once $routeHelperFile;
        }

        // Загружаем ThemeHelper (функции для работы с темами)
        $themeHelperFile = $flowaxyDir . DS . 'Support' . DS . 'Helpers' . DS . 'ThemeHelper.php';
        if (file_exists($themeHelperFile) && is_readable($themeHelperFile)) {
            require_once $themeHelperFile;
        }

        // Функции хуков из PluginManager загружаются позже, когда PluginManager инициализирован
    }
}
