<?php

declare(strict_types=1);

namespace Flowaxy\Bootstrap;

use Flowaxy\Support\Managers\TimezoneManager;
use Throwable;

use function date_default_timezone_set;
use function getDefaultTimezone;
use function is_string;

// Инициализатор окружения
final class EnvironmentInitializer
{
    // Инициализировать окружение
    public static function initialize(bool $isInstalled): void
    {
        $timezone = getDefaultTimezone();

        if ($isInstalled && class_exists(TimezoneManager::class)) {
            try {
                $tz = TimezoneManager::getInstance()->getTimezoneFromDatabase();
                if (is_string($tz) && !empty($tz)) {
                    if ($tz === 'Europe/Kiev') {
                        $tz = 'Europe/Kyiv';
                    }
                    $timezone = $tz;
                }
            } catch (Throwable $e) {
                // Ignore errors
            }
        }

        if (is_string($timezone) && !empty($timezone)) {
            try {
                date_default_timezone_set($timezone);
            } catch (Throwable $e) {
                date_default_timezone_set(getDefaultTimezone());
            }
        } else {
            date_default_timezone_set(getDefaultTimezone());
        }
    }
}
