<?php

declare(strict_types=1);

namespace Flowaxy\Bootstrap;

use Flowaxy\Core\System\PathResolver;
use Flowaxy\Infrastructure\Config\SystemConfig;
use Throwable;

use function class_exists;
use function defined;
use function define;
use function max;

// Визначення констант системи
final class ConstantsDefiner
{
    // Визначення основних констант системи
    public static function define(string $protocol, string $host): void
    {
        if (!defined('SITE_URL')) {
            define('SITE_URL', $protocol . $host);
        }
        if (!defined('ADMIN_URL')) {
            define('ADMIN_URL', SITE_URL . '/admin');
        }
        if (!defined('UPLOADS_DIR')) {
            $uploadsDir = PathResolver::uploads();
            define('UPLOADS_DIR', $uploadsDir);
        }
        if (!defined('UPLOADS_URL')) {
            define('UPLOADS_URL', SITE_URL . '/uploads/');
        }
        if (!defined('CACHE_DIR')) {
            $cacheDir = PathResolver::cache();
            define('CACHE_DIR', $cacheDir);
        }
        if (!defined('LOGS_DIR')) {
            $logsDir = PathResolver::logs();
            define('LOGS_DIR', $logsDir);
        }
        if (!defined('ADMIN_SESSION_NAME')) {
            define('ADMIN_SESSION_NAME', 'cms_admin_logged_in');
        }
        if (!defined('CSRF_TOKEN_NAME')) {
            define('CSRF_TOKEN_NAME', 'csrf_token');
        }

        // PASSWORD_MIN_LENGTH завантажується з налаштувань через SystemConfig
        if (!defined('PASSWORD_MIN_LENGTH')) {
            $minPasswordLength = 8;
            if (class_exists(SystemConfig::class)) {
                try {
                    $systemConfig = SystemConfig::getInstance();
                    $minPasswordLength = $systemConfig->getPasswordMinLength();
                } catch (Throwable) {
                    // Використовуємо значення за замовчуванням
                }
            }
            define('PASSWORD_MIN_LENGTH', max(4, (int)$minPasswordLength));
        }
    }
}
