<?php
/**
 * Testimonials Widget
 * Виджет видео отзывов клиентов
 */

$title = $title ?? 'Відео відгуки клієнтів';
$viewAllLink = $viewAllLink ?? '#';
$testimonials = $testimonials ?? [
    ['url' => '#', 'thumbnail' => '', 'duration' => '5:23'],
    ['url' => '#', 'thumbnail' => '', 'duration' => '8:45'],
    ['url' => '#', 'thumbnail' => '', 'duration' => '3:56'],
    ['url' => '#', 'thumbnail' => '', 'duration' => '12:12']
];
?>

<div class="testimonials-widget">
    <section class="testimonials-section">
        <div class="section-header">
            <h2 class="section-title"><?php echo htmlspecialchars($title, ENT_QUOTES, 'UTF-8'); ?></h2>
            <a href="<?php echo htmlspecialchars($viewAllLink, ENT_QUOTES, 'UTF-8'); ?>" class="section-link">ВСІ ВІДЕО ></a>
        </div>
        <div class="testimonials-grid">
            <?php foreach ($testimonials as $testimonial): ?>
                <div class="testimonial-item">
                    <?php if (!empty($testimonial['url'])): ?>
                        <a href="<?php echo htmlspecialchars($testimonial['url'], ENT_QUOTES, 'UTF-8'); ?>" class="testimonial-link">
                    <?php endif; ?>
                    <div class="testimonial-thumbnail">
                        <?php if (!empty($testimonial['thumbnail'])): ?>
                            <img src="<?php echo htmlspecialchars($testimonial['thumbnail'], ENT_QUOTES, 'UTF-8'); ?>" alt="<?php echo htmlspecialchars($testimonial['title'] ?? '', ENT_QUOTES, 'UTF-8'); ?>" class="testimonial-image">
                        <?php endif; ?>
                        <?php if (!empty($testimonial['duration'])): ?>
                            <span class="testimonial-duration"><?php echo htmlspecialchars($testimonial['duration'], ENT_QUOTES, 'UTF-8'); ?></span>
                        <?php endif; ?>
                    </div>
                    <?php if (!empty($testimonial['url'])): ?>
                        </a>
                    <?php endif; ?>
                </div>
            <?php endforeach; ?>
        </div>
    </section>
</div>

<?php
$cssFile = __DIR__ . '/widget.css';
if (file_exists($cssFile)) {
    $cssUrl = '/content/themes/default/widgets/testimonials/widget.css';
    $version = filemtime($cssFile);
    echo '<link rel="stylesheet" href="' . htmlspecialchars($cssUrl, ENT_QUOTES, 'UTF-8') . '?v=' . $version . '">';
}

$responsiveFile = __DIR__ . '/responsive.css';
if (file_exists($responsiveFile)) {
    $responsiveUrl = '/content/themes/default/widgets/testimonials/responsive.css';
    $responsiveVersion = filemtime($responsiveFile);
    echo '<link rel="stylesheet" href="' . htmlspecialchars($responsiveUrl, ENT_QUOTES, 'UTF-8') . '?v=' . $responsiveVersion . '" media="screen">';
}
?>
