<?php
/**
 * Portfolio Widget
 * Виджет портфолио
 */

$title = $title ?? 'Портфоліо';
$viewAllLink = $viewAllLink ?? '#';
$items = $items ?? $photos ?? [
    ['url' => '#', 'image' => ''],
    ['url' => '#', 'image' => ''],
    ['url' => '#', 'image' => ''],
    ['url' => '#', 'image' => ''],
    ['url' => '#', 'image' => ''],
    ['url' => '#', 'image' => '']
];
?>

<div class="portfolio-widget">
    <section class="portfolio-section">
        <div class="section-header">
            <h2 class="section-title"><?php echo htmlspecialchars($title, ENT_QUOTES, 'UTF-8'); ?></h2>
            <a href="<?php echo htmlspecialchars($viewAllLink, ENT_QUOTES, 'UTF-8'); ?>" class="section-link">ВСЕ ПОРТФОЛІО ></a>
        </div>
        <div class="portfolio-grid">
            <?php foreach ($items as $item): ?>
                <div class="portfolio-item">
                    <?php if (!empty($item['image'])): ?>
                        <a href="<?php echo htmlspecialchars($item['url'] ?? '#', ENT_QUOTES, 'UTF-8'); ?>" class="portfolio-link">
                            <img src="<?php echo htmlspecialchars($item['image'], ENT_QUOTES, 'UTF-8'); ?>" alt="<?php echo htmlspecialchars($item['alt'] ?? '', ENT_QUOTES, 'UTF-8'); ?>" class="portfolio-image">
                        </a>
                    <?php else: ?>
                        <div class="portfolio-placeholder"></div>
                    <?php endif; ?>
                </div>
            <?php endforeach; ?>
        </div>
    </section>
</div>

<?php
$cssFile = __DIR__ . '/widget.css';
if (file_exists($cssFile)) {
    $cssUrl = '/content/themes/default/widgets/portfolio/widget.css';
    $version = filemtime($cssFile);
    echo '<link rel="stylesheet" href="' . htmlspecialchars($cssUrl, ENT_QUOTES, 'UTF-8') . '?v=' . $version . '">';
}

$responsiveFile = __DIR__ . '/responsive.css';
if (file_exists($responsiveFile)) {
    $responsiveUrl = '/content/themes/default/widgets/portfolio/responsive.css';
    $responsiveVersion = filemtime($responsiveFile);
    echo '<link rel="stylesheet" href="' . htmlspecialchars($responsiveUrl, ENT_QUOTES, 'UTF-8') . '?v=' . $responsiveVersion . '" media="screen">';
}
?>
