<?php
/**
 * Marketplace Widget
 * Виджет магазина плагинов и тем
 */

$title = $title ?? 'Магазин плагінів і тем';
$description = $description ?? 'Розширення та теми для Flowaxy CMS. Підвищте функціональність вашого сайту';
$categories = $categories ?? [
    ['name' => 'Плагіни', 'icon' => '■'],
    ['name' => 'Теми', 'icon' => '■'],
    ['name' => 'Віджети', 'icon' => '■'],
    ['name' => 'Модулі', 'icon' => '■'],
    ['name' => 'Інтеграції', 'icon' => '■'],
    ['name' => 'Шаблони', 'icon' => '■'],
    ['name' => 'Іконки', 'icon' => '■'],
    ['name' => 'Бібліотеки', 'icon' => '■']
];
?>

<div class="marketplace-widget">
    <section class="marketplace-section">
        <h1 class="section-title-large"><?php echo htmlspecialchars($title, ENT_QUOTES, 'UTF-8'); ?></h1>
        <p class="section-description"><?php echo htmlspecialchars($description, ENT_QUOTES, 'UTF-8'); ?></p>
        <div class="marketplace-grid">
            <?php foreach ($categories as $category): ?>
                <div class="marketplace-item">
                    <div class="marketplace-icon"><?php echo htmlspecialchars($category['icon'] ?? '■', ENT_QUOTES, 'UTF-8'); ?></div>
                    <div class="marketplace-name"><?php echo htmlspecialchars($category['name'] ?? '', ENT_QUOTES, 'UTF-8'); ?></div>
                </div>
            <?php endforeach; ?>
        </div>
    </section>
</div>

<?php
$cssFile = __DIR__ . '/widget.css';
if (file_exists($cssFile)) {
    $cssUrl = '/content/themes/default/widgets/marketplace/widget.css';
    $version = filemtime($cssFile);
    echo '<link rel="stylesheet" href="' . htmlspecialchars($cssUrl, ENT_QUOTES, 'UTF-8') . '?v=' . $version . '">';
}

$responsiveFile = __DIR__ . '/responsive.css';
if (file_exists($responsiveFile)) {
    $responsiveUrl = '/content/themes/default/widgets/marketplace/responsive.css';
    $responsiveVersion = filemtime($responsiveFile);
    echo '<link rel="stylesheet" href="' . htmlspecialchars($responsiveUrl, ENT_QUOTES, 'UTF-8') . '?v=' . $responsiveVersion . '" media="screen">';
}
?>
