<?php
/**
 * Blogs Widget
 * Виджет блогов
 */

$title = $title ?? 'Блог';
$viewAllLink = $viewAllLink ?? '#';
$blogs = $blogs ?? [
    [
        'author' => 'Олександр Петренко',
        'time' => 'сьогодні о 10:30',
        'title' => 'Тренди веб-дизайну 2025: що буде популярним',
        'excerpt' => 'Розглядаємо основні тренди веб-дизайну на 2025 рік. Мінімалізм, темні теми, анімації та інші актуальні напрямки...',
        'categories' => 'Дизайн, Тренди',
        'url' => '#'
    ],
    [
        'author' => 'Марія Коваленко',
        'time' => 'вчора о 09:15',
        'title' => 'Як обрати CMS для вашого проекту',
        'excerpt' => 'Детальний огляд популярних систем управління контентом. Порівняння функціоналу, безпеки та зручності використання...',
        'categories' => 'Розробка, CMS',
        'url' => '#'
    ],
    [
        'author' => 'Дмитро Іваненко',
        'time' => '2 дні тому о 08:00',
        'title' => 'Мобільна адаптивність: чому це важливо',
        'excerpt' => 'Навіщо потрібна адаптивна верстка та як вона впливає на конверсію та позиції в пошукових системах...',
        'categories' => 'Розробка, SEO',
        'url' => '#'
    ]
];
?>

<div class="blogs-widget">
    <section class="content-section">
        <div class="section-header">
            <h2 class="section-title"><?php echo htmlspecialchars($title, ENT_QUOTES, 'UTF-8'); ?></h2>
            <a href="<?php echo htmlspecialchars($viewAllLink, ENT_QUOTES, 'UTF-8'); ?>" class="section-link">ВСІ СТАТТІ ></a>
        </div>
        <div class="blogs-list">
            <?php foreach ($blogs as $blog): ?>
                <article class="blog-card">
                    <?php if (!empty($blog['url'])): ?>
                        <a href="<?php echo htmlspecialchars($blog['url'], ENT_QUOTES, 'UTF-8'); ?>" class="blog-card-link">
                    <?php endif; ?>
                    <div class="blog-header">
                        <span class="blog-author"><?php echo htmlspecialchars($blog['author'] ?? '', ENT_QUOTES, 'UTF-8'); ?></span>
                        <span class="blog-time"><?php echo htmlspecialchars($blog['time'] ?? '', ENT_QUOTES, 'UTF-8'); ?></span>
                    </div>
                    <h3 class="blog-title"><?php echo htmlspecialchars($blog['title'] ?? '', ENT_QUOTES, 'UTF-8'); ?></h3>
                    <p class="blog-excerpt"><?php echo htmlspecialchars($blog['excerpt'] ?? '', ENT_QUOTES, 'UTF-8'); ?></p>
                    <div class="blog-channel"><?php echo htmlspecialchars($blog['categories'] ?? '', ENT_QUOTES, 'UTF-8'); ?></div>
                    <?php if (!empty($blog['url'])): ?>
                        </a>
                    <?php endif; ?>
                </article>
            <?php endforeach; ?>
        </div>
    </section>
</div>

<?php
$cssFile = __DIR__ . '/widget.css';
if (file_exists($cssFile)) {
    $cssUrl = '/content/themes/default/widgets/blogs/widget.css';
    $version = filemtime($cssFile);
    echo '<link rel="stylesheet" href="' . htmlspecialchars($cssUrl, ENT_QUOTES, 'UTF-8') . '?v=' . $version . '">';
}

$responsiveFile = __DIR__ . '/responsive.css';
if (file_exists($responsiveFile)) {
    $responsiveUrl = '/content/themes/default/widgets/blogs/responsive.css';
    $responsiveVersion = filemtime($responsiveFile);
    echo '<link rel="stylesheet" href="' . htmlspecialchars($responsiveUrl, ENT_QUOTES, 'UTF-8') . '?v=' . $responsiveVersion . '" media="screen">';
}
?>
