<?php

/**
 * Шаблон главной страницы
 * Использует layout main и определяет секцию content
 */

// Виджеты
$activeWidgets = [
    [
        'name' => 'marketplace',
        'data' => [
            'title' => 'Магазин плагінів і тем',
            'description' => 'Розширення та теми для Flowaxy CMS. Підвищте функціональність вашого сайту',
            'categories' => [
                ['name' => 'Плагіни', 'icon' => '■'],
                ['name' => 'Теми', 'icon' => '■'],
                ['name' => 'Віджети', 'icon' => '■'],
                ['name' => 'Модулі', 'icon' => '■'],
                ['name' => 'Інтеграції', 'icon' => '■'],
                ['name' => 'Шаблони', 'icon' => '■'],
                ['name' => 'Іконки', 'icon' => '■'],
                ['name' => 'Бібліотеки', 'icon' => '■']
            ]
        ]
    ],
    [
        'name' => 'portfolio',
        'data' => [
            'title' => 'Портфоліо',
            'viewAllLink' => '#',
            'items' => array_fill(0, 6, ['url' => '#', 'image' => ''])
        ]
    ],
    [
        'name' => 'blogs',
        'data' => [
            'title' => 'Блог',
            'viewAllLink' => '#',
            'blogs' => [
                [
                    'author' => 'Олександр Петренко',
                    'time' => 'сьогодні о 10:30',
                    'title' => 'Тренди веб-дизайну 2025: що буде популярним',
                    'excerpt' => 'Розглядаємо основні тренди веб-дизайну на 2025 рік. Мінімалізм, темні теми, анімації та інші актуальні напрямки...',
                    'categories' => 'Дизайн, Тренди',
                    'url' => '#'
                ],
                [
                    'author' => 'Марія Коваленко',
                    'time' => 'вчора о 09:15',
                    'title' => 'Як обрати CMS для вашого проекту',
                    'excerpt' => 'Детальний огляд популярних систем управління контентом. Порівняння функціоналу, безпеки та зручності використання...',
                    'categories' => 'Розробка, CMS',
                    'url' => '#'
                ],
                [
                    'author' => 'Дмитро Іваненко',
                    'time' => '2 дні тому о 08:00',
                    'title' => 'Мобільна адаптивність: чому це важливо',
                    'excerpt' => 'Навіщо потрібна адаптивна верстка та як вона впливає на конверсію та позиції в пошукових системах...',
                    'categories' => 'Розробка, SEO',
                    'url' => '#'
                ]
            ]
        ]
    ],
    [
        'name' => 'testimonials',
        'data' => [
            'title' => 'Відео відгуки клієнтів',
            'viewAllLink' => '#',
            'testimonials' => [
                ['url' => '#', 'thumbnail' => '', 'duration' => '5:23'],
                ['url' => '#', 'thumbnail' => '', 'duration' => '8:45'],
                ['url' => '#', 'thumbnail' => '', 'duration' => '3:56'],
                ['url' => '#', 'thumbnail' => '', 'duration' => '12:12']
            ]
        ]
    ]
];

// Используем extend для подключения layout
\Flowaxy\Support\Theme\Theme::extend('main', [
    'content' => function () use ($activeWidgets) {
        // Slider
        theme_component('slider');

        // Виджеты
        foreach ($activeWidgets as $widget) {
            if (!isset($widget['name'])) continue;
            $widgetFile = __DIR__ . '/../widgets/' . $widget['name'] . '/widget.php';
            if (!file_exists($widgetFile)) continue;
            $widgetData = $widget['data'] ?? [];
            (function () use ($widgetData, $widgetFile) {
                extract($widgetData, EXTR_OVERWRITE);
                include $widgetFile;
            })();
        }
    }
]);
