/* ============================================
   FLOWAXY THEME FRAMEWORK
   Каркас темы - статичный, не изменяется
   ============================================ */

/**
 * Переключение мобильного бокового меню
 */
function toggleMobileSidebar() {
    const sidebar = document.getElementById('mobileSidebarMenu');
    const overlay = document.getElementById('mobileOverlay');
    const header = document.querySelector('.site-header');

    if (sidebar && overlay) {
        const isOpen = sidebar.classList.contains('mobile-show');

        if (isOpen) {
            sidebar.classList.remove('mobile-show');
            overlay.classList.remove('show');
            document.body.classList.remove('mobile-menu-open');
            document.body.style.overflow = '';
            if (header) {
                header.style.boxShadow = '';
            }
        } else {
            // Вычисляем точную высоту хедера
            if (header) {
                const headerHeight = header.offsetHeight;
                sidebar.style.top = headerHeight + 'px';
                overlay.style.top = headerHeight + 'px';
                // Убираем тень хедера чтобы не было визуальной полоски
                header.style.boxShadow = 'none';
            }
            sidebar.classList.add('mobile-show');
            overlay.classList.add('show');
            document.body.classList.add('mobile-menu-open');
            document.body.style.overflow = 'hidden';
        }
    }
}

/**
 * Переключение модального окна авторизации
 */
function toggleMobileAuth() {
    const modal = document.getElementById('mobileAuthModal');
    const overlay = document.getElementById('mobileAuthOverlay');

    if (modal && overlay) {
        const isOpen = modal.classList.contains('show');

        if (isOpen) {
            modal.classList.remove('show');
            overlay.classList.remove('show');
            document.body.classList.remove('mobile-auth-open');
            document.body.style.overflow = '';
        } else {
            modal.classList.add('show');
            overlay.classList.add('show');
            document.body.classList.add('mobile-auth-open');
            document.body.style.overflow = 'hidden';
        }
    }
}

/**
 * Инициализация каркаса темы
 */
jQuery(function($) {
    'use strict';

    const $mobileMenuToggle = $('#mobileMenuToggle');
    const $mobileOverlay = $('#mobileOverlay');
    const $mobileAuthToggle = $('#mobileAuthToggle');
    const $mobileAuthOverlay = $('#mobileAuthOverlay');
    const $mobileAuthClose = $('#mobileAuthClose');

    if ($mobileMenuToggle.length > 0) {
        $mobileMenuToggle.off('click').on('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            toggleMobileSidebar();
            return false;
        });
    }

    if ($mobileOverlay.length > 0) {
        $mobileOverlay.off('click').on('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            toggleMobileSidebar();
            return false;
        });
    }

    if ($mobileAuthToggle.length > 0) {
        $mobileAuthToggle.off('click').on('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            toggleMobileAuth();
            return false;
        });
    }

    if ($mobileAuthOverlay.length > 0) {
        $mobileAuthOverlay.off('click').on('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            toggleMobileAuth();
            return false;
        });
    }

    if ($mobileAuthClose.length > 0) {
        $mobileAuthClose.off('click').on('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            toggleMobileAuth();
            return false;
        });
    }

    $('.mobile-nav-item').off('click').on('click', function() {
        setTimeout(toggleMobileSidebar, 300);
    });

    $(document).off('keydown.mobileMenu').on('keydown.mobileMenu', function(e) {
        if (e.key === 'Escape') {
            const sidebar = document.getElementById('mobileSidebarMenu');
            if (sidebar && sidebar.classList.contains('mobile-show')) {
                toggleMobileSidebar();
            }
        }
    });

    $(document).off('keydown.mobileAuth').on('keydown.mobileAuth', function(e) {
        if (e.key === 'Escape') {
            const modal = document.getElementById('mobileAuthModal');
            if (modal && modal.classList.contains('show')) {
                toggleMobileAuth();
            }
        }
    });
});

window.toggleMobileSidebar = toggleMobileSidebar;
window.toggleMobileAuth = toggleMobileAuth;
