<?php

/**
 * Основной макет темы Flowaxy
 * Содержит общую структуру: header, footer, модальные окна
 */

// Вспомогательная функция для генерации версии файла
function theme_asset_version($file)
{
    static $cache = [];
    if (!isset($cache[$file])) {
        $fullPath = __DIR__ . '/../' . $file;
        $cache[$file] = file_exists($fullPath) ? filemtime($fullPath) : time();
    }
    return '?v=' . $cache[$file];
}

// Получение имени сайта
$siteName = $headerSiteName ?? 'flowaxy';
if (class_exists('\Flowaxy\Support\Managers\SettingsManager')) {
    try {
        $settingsManager = \Flowaxy\Support\Managers\SettingsManager::getInstance();
        if ($settingsManager) {
            $siteName = $settingsManager->get('site_name', $siteName);
        }
    } catch (\Throwable $e) {
    }
}

// Определение текущей страницы
$currentUri = parse_url($_SERVER['REQUEST_URI'] ?? '/', PHP_URL_PATH);
$isHomePage = in_array($currentUri, ['/', '', '/index.php'], true);

// Меню шапки
$headerMenu = [
    ['name' => 'ГОЛОВНА', 'url' => '#', 'key' => 'home'],
    ['name' => 'ПОСЛУГИ', 'url' => '#', 'key' => 'services'],
    ['name' => 'ПОРТФОЛІО', 'url' => '#', 'key' => 'portfolio'],
    ['name' => 'БЛОГ', 'url' => '#', 'key' => 'blog'],
    ['name' => 'ПРО НАС', 'url' => '#', 'key' => 'about'],
    ['name' => 'КОНТАКТИ', 'url' => '#', 'key' => 'contacts']
];

// Мобильное меню
$mobileMenuItems = [
    ['name' => 'ГОЛОВНА', 'url' => '#', 'icon' => 'fas fa-home'],
    ['name' => 'ПОСЛУГИ', 'url' => '#', 'icon' => 'fas fa-briefcase'],
    ['name' => 'ПОРТФОЛІО', 'url' => '#', 'icon' => 'fas fa-folder-open'],
    ['name' => 'БЛОГ', 'url' => '#', 'icon' => 'fas fa-blog'],
    ['name' => 'ПРО НАС', 'url' => '#', 'icon' => 'fas fa-info-circle'],
    ['name' => 'КОНТАКТИ', 'url' => '#', 'icon' => 'fas fa-envelope']
];

// Структура категорий для сайдбара
$categoriesStructure = [
    'services' => [
        'name' => 'Послуги',
        'icon' => 'fas fa-briefcase',
        'url' => '#',
        'subcategories' => [
            ['name' => 'Розробка сайтів', 'icon' => 'fas fa-code', 'url' => '#'],
            ['name' => 'Веб-дизайн', 'icon' => 'fas fa-paint-brush', 'url' => '#'],
            ['name' => 'Мобільні додатки', 'icon' => 'fas fa-mobile-alt', 'url' => '#'],
            ['name' => 'E-commerce', 'icon' => 'fas fa-shopping-cart', 'url' => '#'],
            ['name' => 'SEO оптимізація', 'icon' => 'fas fa-search', 'url' => '#'],
            ['name' => 'Підтримка', 'icon' => 'fas fa-headset', 'url' => '#']
        ]
    ],
    'portfolio' => [
        'name' => 'Портфоліо',
        'icon' => 'fas fa-folder-open',
        'url' => '#',
        'subcategories' => [
            ['name' => 'Всі проекти', 'icon' => 'fas fa-th', 'url' => '#'],
            ['name' => 'Веб-сайти', 'icon' => 'fas fa-globe', 'url' => '#'],
            ['name' => 'Мобільні додатки', 'icon' => 'fas fa-mobile-alt', 'url' => '#'],
            ['name' => 'E-commerce', 'icon' => 'fas fa-store', 'url' => '#'],
            ['name' => 'Кейси', 'icon' => 'fas fa-folder', 'url' => '#']
        ]
    ],
    'blog' => [
        'name' => 'Блог',
        'icon' => 'fas fa-blog',
        'url' => '#',
        'subcategories' => [
            ['name' => 'Всі статті', 'icon' => 'fas fa-list', 'url' => '#'],
            ['name' => 'Розробка', 'icon' => 'fas fa-code', 'url' => '#'],
            ['name' => 'Дизайн', 'icon' => 'fas fa-palette', 'url' => '#'],
            ['name' => 'Маркетинг', 'icon' => 'fas fa-chart-line', 'url' => '#'],
            ['name' => 'Новини', 'icon' => 'fas fa-newspaper', 'url' => '#']
        ]
    ],
    'about' => [
        'name' => 'Про нас',
        'icon' => 'fas fa-info-circle',
        'url' => '#',
        'subcategories' => [
            ['name' => 'Про компанію', 'icon' => 'fas fa-building', 'url' => '#'],
            ['name' => 'Наша команда', 'icon' => 'fas fa-users', 'url' => '#'],
            ['name' => 'Історія', 'icon' => 'fas fa-history', 'url' => '#'],
            ['name' => 'Нагороди', 'icon' => 'fas fa-trophy', 'url' => '#']
        ]
    ],
    'contacts' => [
        'name' => 'Контакти',
        'icon' => 'fas fa-envelope',
        'url' => '#',
        'subcategories' => [
            ['name' => 'Зв\'язатися з нами', 'icon' => 'fas fa-phone', 'url' => '#'],
            ['name' => 'Офіси', 'icon' => 'fas fa-map-marker-alt', 'url' => '#'],
            ['name' => 'Форма зворотного зв\'язку', 'icon' => 'fas fa-comment', 'url' => '#']
        ]
    ]
];

// Определение текущей категории
$currentCategory = 'services';
foreach (['portfolio', 'blog', 'about', 'contacts'] as $cat) {
    if (stripos($currentUri, $cat) !== false) {
        $currentCategory = $cat;
        break;
    }
}
$currentCategoryData = $categoriesStructure[$currentCategory] ?? $categoriesStructure['services'];

// Информационные блоки для главной страницы
$infoBlocks = [
    ['icon' => 'fas fa-gift', 'title' => 'Пропозиція', 'text' => 'Знижка 20% на розробку сайту при замовленні до кінця місяця'],
    ['icon' => 'fas fa-star', 'title' => 'Бонусна програма', 'text' => 'Отримайте безкоштовну підтримку на 3 місяці при замовленні повного пакету'],
    ['icon' => 'fas fa-handshake', 'title' => 'Партнерська програма', 'text' => 'За привлечения заказчика получаете 15% от чистой прибили студии'],
    ['icon' => 'fas fa-code', 'title' => 'Соло розробник', 'text' => 'Более 100 закавоза 2025']
];

// Меню футера
$footerMenu = [
    ['name' => 'ПРО НАС', 'url' => '#'],
    ['name' => 'ПОСЛУГИ', 'url' => '#'],
    ['name' => 'ПОРТФОЛІО', 'url' => '#'],
    ['name' => 'БЛОГ', 'url' => '#'],
    ['name' => 'КОНТАКТИ', 'url' => '#']
];

// Логотип
$logoPath = '/content/admin/resources/images/brand/logo-white.png';
$logoExists = file_exists($_SERVER['DOCUMENT_ROOT'] . $logoPath);
$pageTitle = $pageTitle ?? 'Веб-студія Flowaxy - Розробка сайтів та додатків';
$escSiteName = htmlspecialchars($siteName, ENT_QUOTES, 'UTF-8');
?>
<!DOCTYPE html>
<html lang="uk">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars($pageTitle, ENT_QUOTES, 'UTF-8'); ?></title>
    <script src="/content/themes/default/resources/library/jquery-3.7.1.min.js"></script>
    <link rel="stylesheet" href="/content/themes/default/resources/library/font-awesome/css/all.min.css">
    <link rel="stylesheet" href="/content/themes/default/resources/styles/variables.css<?php echo theme_asset_version('resources/styles/variables.css'); ?>">
    <link rel="stylesheet" href="/content/themes/default/resources/styles/flowaxy.css<?php echo theme_asset_version('resources/styles/flowaxy.css'); ?>">
    <link rel="stylesheet" href="/content/themes/default/resources/styles/responsive.css<?php echo theme_asset_version('resources/styles/responsive.css'); ?>">
</head>

<body>
    <header class="site-header">
        <div class="header-top">
            <div class="header-left">
                <button class="mobile-menu-toggle" aria-label="Меню" id="mobileMenuToggle">
                    <i class="fas fa-bars"></i>
                </button>
                <a href="/" class="logo-link">
                    <?php if ($logoExists): ?>
                        <img src="<?php echo htmlspecialchars($logoPath, ENT_QUOTES, 'UTF-8'); ?>" alt="<?php echo $escSiteName; ?>" class="logo-image">
                    <?php else: ?>
                        <span class="logo-text"><?php echo $escSiteName; ?></span>
                    <?php endif; ?>
                </a>
            </div>
            <div class="header-center">
                <nav class="main-nav" aria-label="Main navigation">
                    <?php foreach ($headerMenu as $item): ?>
                        <a href="<?php echo htmlspecialchars($item['url'], ENT_QUOTES, 'UTF-8'); ?>"
                            class="nav-link"
                            <?php if (isset($item['key'])): ?>data-category="<?php echo htmlspecialchars($item['key'], ENT_QUOTES, 'UTF-8'); ?>" <?php endif; ?>>
                            <?php echo htmlspecialchars($item['name'], ENT_QUOTES, 'UTF-8'); ?>
                        </a>
                    <?php endforeach; ?>
                </nav>
            </div>
            <div class="header-right">
                <div class="search-container">
                    <input type="text" class="search-input" placeholder="Пошук...">
                    <button class="search-btn" type="button" aria-label="Поиск">
                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M7 12C9.76142 12 12 9.76142 12 7C12 4.23858 9.76142 2 7 2C4.23858 2 2 4.23858 2 7C2 9.76142 4.23858 12 7 12Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                            <path d="M10.5 10.5L14 14" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                        </svg>
                    </button>
                </div>
                <button class="mobile-auth-link" aria-label="Авторизация" id="mobileAuthToggle">
                    <i class="fas fa-user"></i>
                </button>
            </div>
        </div>
    </header>

    <div class="mobile-auth-overlay" id="mobileAuthOverlay"></div>
    <div class="mobile-auth-modal" id="mobileAuthModal">
        <div class="mobile-auth-header">
            <div class="mobile-auth-title-wrapper">
                <i class="fas fa-user-circle mobile-auth-icon"></i>
                <h2 class="mobile-auth-title">Мій акаунт</h2>
            </div>
            <button class="mobile-auth-close" id="mobileAuthClose" aria-label="Закрити">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <div class="mobile-auth-content">
            <?php theme_component('auth'); ?>
        </div>
    </div>

    <div class="mobile-overlay" id="mobileOverlay"></div>
    <aside class="mobile-sidebar-menu" id="mobileSidebarMenu">
        <nav class="mobile-sidebar-nav">
            <?php foreach ($mobileMenuItems as $item): ?>
                <a href="<?php echo htmlspecialchars($item['url'], ENT_QUOTES, 'UTF-8'); ?>" class="mobile-nav-item">
                    <i class="<?php echo htmlspecialchars($item['icon'], ENT_QUOTES, 'UTF-8'); ?> mobile-nav-icon"></i>
                    <span><?php echo htmlspecialchars($item['name'], ENT_QUOTES, 'UTF-8'); ?></span>
                </a>
            <?php endforeach; ?>
        </nav>
    </aside>

    <div class="main-layout">
        <aside class="sidebar-left">
            <?php if ($isHomePage): ?>
                <div class="sidebar-section sidebar-info-section">
                    <h3 class="sidebar-title">АКЦІЇ ТА БОНУСИ</h3>
                    <div class="sidebar-info">
                        <?php foreach ($infoBlocks as $block): ?>
                            <div class="info-item">
                                <div class="info-icon info-icon-right">
                                    <i class="<?php echo htmlspecialchars($block['icon'], ENT_QUOTES, 'UTF-8'); ?>"></i>
                                </div>
                                <div class="info-content">
                                    <h4 class="info-title"><?php echo htmlspecialchars($block['title'], ENT_QUOTES, 'UTF-8'); ?></h4>
                                    <p class="info-text"><?php echo htmlspecialchars($block['text'], ENT_QUOTES, 'UTF-8'); ?></p>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            <?php else: ?>
                <div class="sidebar-section sidebar-nav-section">
                    <h3 class="sidebar-title">НАВІГАЦІЯ</h3>
                    <nav class="sidebar-nav" id="sidebarNav">
                        <div class="nav-categories">
                            <?php foreach ($categoriesStructure as $key => $category): ?>
                                <a href="<?php echo htmlspecialchars($category['url'], ENT_QUOTES, 'UTF-8'); ?>"
                                    class="nav-item <?php echo $key === $currentCategory ? 'active' : ''; ?>"
                                    data-category="<?php echo htmlspecialchars($key, ENT_QUOTES, 'UTF-8'); ?>">
                                    <i class="<?php echo htmlspecialchars($category['icon'], ENT_QUOTES, 'UTF-8'); ?> nav-icon"></i>
                                    <span class="nav-text"><?php echo htmlspecialchars($category['name'], ENT_QUOTES, 'UTF-8'); ?></span>
                                    <?php if (!empty($category['subcategories'])): ?>
                                        <i class="fas fa-chevron-right nav-arrow"></i>
                                    <?php endif; ?>
                                </a>
                            <?php endforeach; ?>
                        </div>
                        <?php if (!empty($currentCategoryData['subcategories'])): ?>
                            <div class="nav-subcategories active" id="navSubcategories">
                                <?php foreach ($currentCategoryData['subcategories'] as $subcategory): ?>
                                    <a href="<?php echo htmlspecialchars($subcategory['url'], ENT_QUOTES, 'UTF-8'); ?>" class="nav-subitem">
                                        <i class="<?php echo htmlspecialchars($subcategory['icon'], ENT_QUOTES, 'UTF-8'); ?> nav-subicon"></i>
                                        <span class="nav-subtext"><?php echo htmlspecialchars($subcategory['name'], ENT_QUOTES, 'UTF-8'); ?></span>
                                    </a>
                                <?php endforeach; ?>
                            </div>
                        <?php endif; ?>
                    </nav>
                </div>
            <?php endif; ?>
        </aside>

        <main class="content-main">
            <?php echo \Flowaxy\Support\Theme\Theme::yield('content', ''); ?>
        </main>

        <aside class="sidebar-right">
            <?php theme_component('auth'); ?>
        </aside>
    </div>

    <footer class="site-footer">
        <div class="footer-row">
            <div class="footer-left">
                <div class="footer-copyright">
                    <span class="footer-copyright-symbol">©</span>
                    <span class="footer-year"><?php echo date('Y'); ?></span>
                    <a href="/" class="footer-domain"><?php echo htmlspecialchars(strtoupper($_SERVER['HTTP_HOST'] ?? 'flowaxy.com'), ENT_QUOTES, 'UTF-8'); ?></a>
                </div>
            </div>
            <div class="footer-center">
                <?php foreach ($footerMenu as $item): ?>
                    <a href="<?php echo htmlspecialchars($item['url'], ENT_QUOTES, 'UTF-8'); ?>" class="footer-link">
                        <?php echo htmlspecialchars($item['name'], ENT_QUOTES, 'UTF-8'); ?>
                    </a>
                <?php endforeach; ?>
            </div>
            <div class="footer-right">
                <div class="footer-share">
                    <?php theme_component('social-networks'); ?>
                </div>
            </div>
        </div>
    </footer>

    <script src="/content/themes/default/resources/scripts/flowaxy.js<?php echo theme_asset_version('resources/scripts/flowaxy.js'); ?>"></script>
</body>

</html>
