<?php

/**
 * Настройки кастоматизации темы Default
 *
 * Этот файл содержит массив настроек кастоматизации, которые админка использует
 * для отображения формы настройки темы.
 *
 * Структура:
 * - Каждая секция (section) содержит группу связанных настроек
 * - Каждое поле (field) имеет тип, название, описание и значение по умолчанию
 */

return [
    'colors' => [
        'title' => 'Цвета',
        'description' => 'Настройка цветовой схемы темы',
        'fields' => [
            'primary_color' => [
                'type' => 'color',
                'label' => 'Основной цвет',
                'description' => 'Основной акцентный цвет темы (используется для кнопок, ссылок и акцентов)',
                'default' => '#4CAF50',
                'value' => '#4CAF50',
            ],
            'secondary_color' => [
                'type' => 'color',
                'label' => 'Вторичный цвет',
                'description' => 'Дополнительный цвет для элементов интерфейса',
                'default' => '#45a049',
                'value' => '#45a049',
            ],
            'background_color' => [
                'type' => 'color',
                'label' => 'Цвет фона',
                'description' => 'Основной цвет фона страницы',
                'default' => '#f8f9fa',
                'value' => '#f8f9fa',
            ],
            'text_color' => [
                'type' => 'color',
                'label' => 'Цвет текста',
                'description' => 'Основной цвет текста на странице',
                'default' => '#333333',
                'value' => '#333333',
            ],
        ],
    ],
    'typography' => [
        'title' => 'Типографика',
        'description' => 'Настройка шрифтов и типографики',
        'fields' => [
            'font_family' => [
                'type' => 'select',
                'label' => 'Семейство шрифтов',
                'description' => 'Основной шрифт для текста сайта',
                'default' => 'sans-serif',
                'value' => 'sans-serif',
                'options' => [
                    'sans-serif' => 'Sans Serif (системный)',
                    'serif' => 'Serif (с засечками)',
                    'monospace' => 'Monospace (моноширинный)',
                    'Arial' => 'Arial',
                    'Helvetica' => 'Helvetica',
                    'Georgia' => 'Georgia',
                    'Times New Roman' => 'Times New Roman',
                ],
            ],
            'font_size_base' => [
                'type' => 'number',
                'label' => 'Базовый размер шрифта (px)',
                'description' => 'Размер шрифта по умолчанию для основного текста',
                'default' => '16',
                'value' => '16',
                'min' => '12',
                'max' => '24',
                'step' => '1',
            ],
        ],
    ],
    'layout' => [
        'title' => 'Макет',
        'description' => 'Настройка размеров и отступов',
        'fields' => [
            'content_max_width' => [
                'type' => 'number',
                'label' => 'Максимальная ширина контента (px)',
                'description' => 'Максимальная ширина центрального блока контента',
                'default' => '1400',
                'value' => '1400',
                'min' => '800',
                'max' => '2000',
                'step' => '50',
            ],
            'content_padding' => [
                'type' => 'number',
                'label' => 'Горизонтальные отступы контента (px)',
                'description' => 'Отступы слева и справа от краев экрана',
                'default' => '20',
                'value' => '20',
                'min' => '0',
                'max' => '100',
                'step' => '5',
            ],
        ],
    ],
    'header' => [
        'title' => 'Шапка сайта',
        'description' => 'Настройки шапки (header)',
        'fields' => [
            'header_height' => [
                'type' => 'number',
                'label' => 'Высота шапки (px)',
                'description' => 'Высота шапки сайта',
                'default' => '60',
                'value' => '60',
                'min' => '40',
                'max' => '120',
                'step' => '5',
            ],
            'header_sticky' => [
                'type' => 'select',
                'label' => 'Закрепление шапки',
                'description' => 'Должна ли шапка оставаться видимой при прокрутке',
                'default' => 'no',
                'value' => 'no',
                'options' => [
                    'no' => 'Нет',
                    'yes' => 'Да',
                ],
            ],
        ],
    ],
    'footer' => [
        'title' => 'Подвал сайта',
        'description' => 'Настройки подвала (footer)',
        'fields' => [
            'footer_text' => [
                'type' => 'textarea',
                'label' => 'Текст копирайта',
                'description' => 'Текст, отображаемый в подвале сайта',
                'default' => '2026 flowaxy.com все права захищени',
                'value' => '2026 flowaxy.com все права захищени',
            ],
        ],
    ],
];
