<?php
/**
 * Social Networks Component
 */

$networks = [];
if (class_exists('\Flowaxy\Core\Hooks\Filter')) {
    $networks = \Flowaxy\Core\Hooks\Filter::apply('theme_social_networks', $networks, []);
}

$settings = [];
if (class_exists('\Flowaxy\Infrastructure\Config\PluginSettingsManager')) {
    $settings = \Flowaxy\Infrastructure\Config\PluginSettingsManager::getSettings('social-networks');
}

$status = $settings['status'] ?? 'activated';
$validNetworks = [];

if (!empty($networks) && is_array($networks)) {
    foreach ($networks as $network) {
        $url = $network['url'] ?? '#';
        $enabled = $network['enabled'] ?? true;
        if ($enabled && !empty($url) && $url !== '#' && filter_var($url, FILTER_VALIDATE_URL)) {
            $validNetworks[] = $network;
        }
    }
}

if ($status !== 'activated' || empty($validNetworks)) {
    echo '<div class="social-networks-not-configured"><span class="social-networks-message">Плагин не настроен</span></div>';
    return;
}
?>

<div class="social-networks-component">
    <div class="social-share">
        <?php foreach ($validNetworks as $network): ?>
            <a href="<?php echo htmlspecialchars($network['url'] ?? '#', ENT_QUOTES, 'UTF-8'); ?>"
               class="share-icon <?php echo htmlspecialchars($network['id'] ?? '', ENT_QUOTES, 'UTF-8'); ?>"
               title="<?php echo htmlspecialchars($network['name'] ?? '', ENT_QUOTES, 'UTF-8'); ?>"
               target="_blank"
               rel="noopener noreferrer">
                <i class="<?php echo htmlspecialchars($network['icon'] ?? 'fas fa-link', ENT_QUOTES, 'UTF-8'); ?>"></i>
            </a>
        <?php endforeach; ?>
    </div>
</div>
