<?php
/**
 * Slider Component
 * Компонент слайдера
 */

$slides = $slides ?? [
    [
        'title' => 'Професійна розробка сайтів',
        'description' => 'Створюємо сучасні та функціональні веб-сайти, які приносять результат вашому бізнесу',
        'button' => 'Дізнатися більше',
        'bg' => 'slide-bg-1'
    ],
    [
        'title' => 'Веб-дизайн та брендинг',
        'description' => 'Унікальний дизайн, який виділить вас серед конкурентів та залучить нових клієнтів',
        'button' => 'Почати проект',
        'bg' => 'slide-bg-2'
    ],
    [
        'title' => 'E-commerce рішення',
        'description' => 'Повнофункціональні інтернет-магазини з інтеграцією платіжних систем та CRM',
        'button' => 'Переглянути кейси',
        'bg' => 'slide-bg-3'
    ]
];
?>

<div class="slider-component">
    <section class="slider-section">
        <div class="slider-container">
            <div class="slider-wrapper">
                <?php foreach ($slides as $index => $slide): ?>
                    <div class="slider-slide <?php echo $index === 0 ? 'active' : ''; ?>" data-slide="<?php echo $index; ?>">
                        <div class="slide-content">
                            <h2 class="slide-title"><?php echo htmlspecialchars($slide['title'] ?? '', ENT_QUOTES, 'UTF-8'); ?></h2>
                            <p class="slide-description"><?php echo htmlspecialchars($slide['description'] ?? '', ENT_QUOTES, 'UTF-8'); ?></p>
                            <button class="slide-btn"><?php echo htmlspecialchars($slide['button'] ?? 'Learn More', ENT_QUOTES, 'UTF-8'); ?></button>
                        </div>
                        <div class="slide-bg <?php echo htmlspecialchars($slide['bg'] ?? 'slide-bg-1', ENT_QUOTES, 'UTF-8'); ?>"></div>
                    </div>
                <?php endforeach; ?>
            </div>
            <div class="slider-controls">
                <button class="slider-btn slider-btn-prev" aria-label="Previous slide">
                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M12 15L7 10L12 5" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                    </svg>
                </button>
                <button class="slider-btn slider-btn-next" aria-label="Next slide">
                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M8 5L13 10L8 15" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" />
                    </svg>
                </button>
            </div>
            <div class="slider-dots">
                <?php foreach ($slides as $index => $slide): ?>
                    <button class="slider-dot <?php echo $index === 0 ? 'active' : ''; ?>" data-slide="<?php echo $index; ?>" aria-label="Go to slide <?php echo $index + 1; ?>"></button>
                <?php endforeach; ?>
            </div>
        </div>
    </section>
</div>

<?php
$jsFile = __DIR__ . '/component.js';
if (file_exists($jsFile)) {
    $jsUrl = '/content/themes/default/components/slider/component.js';
    $version = filemtime($jsFile);
    echo '<script src="' . htmlspecialchars($jsUrl, ENT_QUOTES, 'UTF-8') . '?v=' . $version . '"></script>';
}
?>
