document.addEventListener('DOMContentLoaded', function() {
    const sliderWrapper = document.querySelector('.slider-component .slider-wrapper');
    const slides = document.querySelectorAll('.slider-component .slider-slide');
    const dots = document.querySelectorAll('.slider-component .slider-dot');
    const prevBtn = document.querySelector('.slider-component .slider-btn-prev');
    const nextBtn = document.querySelector('.slider-component .slider-btn-next');

    if (!sliderWrapper || slides.length === 0) {
        return;
    }

    let currentSlide = 0;
    let autoSlideInterval = null;

    function showSlide(index) {
        slides.forEach((slide, i) => {
            slide.classList.toggle('active', i === index);
        });

        dots.forEach((dot, i) => {
            dot.classList.toggle('active', i === index);
        });

        currentSlide = index;
    }

    function nextSlide() {
        const next = (currentSlide + 1) % slides.length;
        showSlide(next);
    }

    function prevSlide() {
        const prev = (currentSlide - 1 + slides.length) % slides.length;
        showSlide(prev);
    }

    function startAutoSlide() {
        stopAutoSlide();
        autoSlideInterval = setInterval(nextSlide, 5000);
    }

    function stopAutoSlide() {
        if (autoSlideInterval) {
            clearInterval(autoSlideInterval);
            autoSlideInterval = null;
        }
    }

    if (nextBtn) {
        nextBtn.addEventListener('click', function() {
            nextSlide();
            startAutoSlide();
        });
    }

    if (prevBtn) {
        prevBtn.addEventListener('click', function() {
            prevSlide();
            startAutoSlide();
        });
    }

    dots.forEach((dot, index) => {
        dot.addEventListener('click', function() {
            showSlide(index);
            startAutoSlide();
        });
    });

    sliderWrapper.addEventListener('mouseenter', stopAutoSlide);
    sliderWrapper.addEventListener('mouseleave', startAutoSlide);

    startAutoSlide();
});
