<?php

/**
 * Auth Component
 * Компонент авторизации и регистрации
 */

$activeTab = $_GET['tab'] ?? 'login';
?>

<div class="auth-component">
    <div class="auth-block">
        <div class="auth-header">
            <button class="btn-login-tab <?php echo $activeTab === 'login' ? 'active' : ''; ?>" data-tab="login">ВХОД</button>
            <button class="btn-register-tab <?php echo $activeTab === 'register' ? 'active' : ''; ?>" data-tab="register">РЕГИСТРАЦИЯ</button>
        </div>

        <!-- Форма входа -->
        <div class="auth-form auth-form-login" id="login-form" style="<?php echo $activeTab === 'login' ? 'display: flex;' : 'display: none;'; ?>">
            <form method="POST" action="/auth/login">
                <div class="form-group">
                    <i class="fas fa-user input-icon"></i>
                    <input type="text" name="username" class="form-input" placeholder="Телефон, E-Mail, ник" required>
                </div>
                <div class="form-group">
                    <i class="fas fa-lock input-icon"></i>
                    <input type="password" name="password" class="form-input" placeholder="Введите пароль" required>
                </div>
                <button type="submit" class="btn-submit">
                    <i class="fas fa-key"></i>
                    <span>Войти</span>
                </button>
                <div class="auth-divider">
                    <span class="divider-line"></span>
                    <span class="divider-text">ИЛИ</span>
                    <span class="divider-line"></span>
                </div>
                <button type="button" class="auth-link-btn">
                    <i class="fas fa-question-circle"></i>
                    <span>Не можете войти?</span>
                </button>
            </form>
        </div>

        <!-- Форма регистрации -->
        <div class="auth-form auth-form-register" id="register-form" style="<?php echo $activeTab === 'register' ? 'display: flex;' : 'display: none;'; ?>">
            <form method="POST" action="/auth/register" autocomplete="off">
                <div class="form-group">
                    <i class="fas fa-user input-icon"></i>
                    <input type="text" name="username" class="form-input" placeholder="Имя пользователя" autocomplete="off" required>
                </div>
                <div class="form-group">
                    <i class="fas fa-envelope input-icon"></i>
                    <input type="email" name="email" class="form-input" placeholder="E-Mail" autocomplete="off" required>
                </div>
                <div class="form-group">
                    <i class="fas fa-lock input-icon"></i>
                    <input type="password" name="password" class="form-input" placeholder="Пароль" autocomplete="new-password" required>
                </div>
                <div class="form-group">
                    <i class="fas fa-lock input-icon"></i>
                    <input type="password" name="password_confirm" class="form-input" placeholder="Подтвердите пароль" autocomplete="new-password" required>
                </div>
                <button type="submit" class="btn-submit">
                    <i class="fas fa-user-plus"></i>
                    <span>Зарегистрироваться</span>
                </button>
            </form>
        </div>
    </div>
</div>

<?php
$jsFile = __DIR__ . '/component.js';
if (file_exists($jsFile)) {
    $jsUrl = '/content/themes/default/components/auth/component.js';
    $version = filemtime($jsFile);
    echo '<script src="' . htmlspecialchars($jsUrl, ENT_QUOTES, 'UTF-8') . '?v=' . $version . '"></script>';
}
?>
