# Default Theme для Flowaxy CMS

Базовая тема по умолчанию для Flowaxy CMS. Оптимизирована и готова к использованию как шаблон для дальнейшей разработки.

## Структура темы

```
default/
├── components/          # Компоненты темы (переиспользуемые блоки)
│   ├── auth/           # Компонент авторизации
│   ├── slider/         # Компонент слайдера
│   └── social-networks/ # Компонент социальных сетей
├── layouts/            # Макеты (общая структура страниц)
│   └── main.php        # Основной макет (header, footer, сайдбары)
├── templates/          # Шаблоны страниц
│   └── default.php     # Шаблон главной страницы
├── widgets/            # Виджеты (блоки контента)
│   ├── marketplace/    # Виджет магазина
│   ├── portfolio/      # Виджет портфолио
│   ├── blogs/          # Виджет блогов
│   └── testimonials/   # Виджет отзывов
├── resources/          # Ресурсы темы
│   ├── fonts/          # Шрифты (Raleway, Kanit)
│   ├── library/        # Библиотеки (jQuery, Font Awesome)
│   ├── scripts/        # JavaScript файлы
│   └── styles/         # CSS файлы
├── Theme.php           # Основной класс темы
└── customization.php   # Настройки кастоматизации
```

## Компоненты

### Auth Component

Компонент авторизации и регистрации пользователей.

-   **Файлы:** `components/auth/component.php`, `component.css`, `component.js`
-   **Использование:** `theme_component('auth')`

### Slider Component

Компонент слайдера изображений.

-   **Файлы:** `components/slider/component.php`, `component.css`, `component.js`
-   **Использование:** `theme_component('slider')`

### Social Networks Component

Компонент социальных сетей (интеграция с плагином social-networks).

-   **Файлы:** `components/social-networks/component.php`, `component.css`
-   **Использование:** `theme_component('social-networks')`

## Layouts

### Main Layout

Основной макет темы, содержит:

-   Header с меню и поиском
-   Мобильные модальные окна (авторизация, меню)
-   Структуру с сайдбарами
-   Footer с меню и социальными сетями

**Использование в template:**

```php
\Flowaxy\Support\Theme\Theme::extend('main', [
    'content' => function() {
        // Ваш контент здесь
    }
]);
```

## Templates

### Default Template

Шаблон главной страницы. Использует layout `main` и определяет секцию `content`.

**Структура:**

-   Slider компонент
-   Виджеты (marketplace, portfolio, blogs, testimonials)

## Widgets

Все виджеты имеют единую структуру:

-   `widget.php` - основной файл виджета
-   `widget.css` - стили виджета
-   `responsive.css` - адаптивные стили

### Marketplace Widget

Виджет магазина плагинов и тем.

### Portfolio Widget

Виджет портфолио проектов.

### Blogs Widget

Виджет блога со статьями.

### Testimonials Widget

Виджет видео отзывов клиентов.

## Ресурсы

### Стили

-   `variables.css` - CSS переменные (дизайн-система)
-   `flowaxy.css` - Основные стили темы
-   `responsive.css` - Адаптивные стили

### Скрипты

-   `flowaxy.js` - Основной JavaScript файл темы (мобильное меню, модальные окна)

### Библиотеки

-   jQuery 3.7.1 (локально)
-   Font Awesome (локально)

### Шрифты

-   Raleway (400, 700, 300, 500, 600)
-   Kanit (400, 700, 300, 500, 600)

## Использование

### Создание нового шаблона

Создайте файл в `templates/` и используйте layout:

```php
<?php
\Flowaxy\Support\Theme\Theme::extend('main', [
    'content' => function() {
        // Ваш контент
    }
]);
?>
```

### Создание нового компонента

1. Создайте папку в `components/`
2. Добавьте `component.php`, `component.css` (опционально), `component.js` (опционально)
3. Используйте: `theme_component('component-name')`

### Создание нового виджета

1. Создайте папку в `widgets/`
2. Добавьте `widget.php`, `widget.css`, `responsive.css`
3. Виджет автоматически загружается через Theme API

## Настройки темы

Настройки кастоматизации определяются в `customization.php`:

-   Цвета
-   Типографика
-   Макет
-   Header
-   Footer

## Технические детали

-   **PHP версия:** 8.0+
-   **Зависимости:** jQuery 3.7.1, Font Awesome
-   **Стиль:** Строгий корпоративный, плоский дизайн
-   **Адаптивность:** Полная поддержка мобильных устройств и планшетов

## Версия

**1.0.0** - Финальная оптимизированная версия, готова к использованию как шаблон.
