<?php

/**
 * Страница управления социальными сетями
 */

function admin_social_networks_page()
{
    $configFile = __DIR__ . DS . '..' . DS . '..' . DS . 'config' . DS . 'networks.ini';
    $networks = [];
    $message = '';
    $messageType = '';

    // Загружаем текущие настройки плагина
    $pluginSlug = 'social-networks';
    $settings = [];
    if (class_exists('\Flowaxy\Infrastructure\Config\PluginSettingsManager')) {
        $settings = \Flowaxy\Infrastructure\Config\PluginSettingsManager::getSettings($pluginSlug);
    }
    $currentStatus = $settings['status'] ?? 'activated';

    // Обработка сохранения
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['action'])) {
        $action = $_POST['action'] ?? '';

        if ($action === 'save_settings') {
            // Сохранение настроек плагина (только статус)
            if (class_exists('\Flowaxy\Infrastructure\Config\PluginSettingsManager')) {
                $newSettings = [
                    'status' => $_POST['status'] ?? 'activated',
                ];

                if (\Flowaxy\Infrastructure\Config\PluginSettingsManager::saveSettings($pluginSlug, $newSettings)) {
                    // Очищаем кеш настроек плагина
                    if (class_exists('\Flowaxy\Support\Helpers\CacheHelper')) {
                        \Flowaxy\Support\Helpers\CacheHelper::forget('plugin_settings_' . $pluginSlug);
                    }
                    $message = 'Настройки успешно сохранены';
                    $messageType = 'success';
                    // Обновляем текущие значения для отображения
                    $currentStatus = $newSettings['status'];
                    $settings = $newSettings;
                } else {
                    $message = 'Ошибка при сохранении настроек';
                    $messageType = 'danger';
                }
            }
        } elseif ($action === 'save') {
            // Сохранение социальных сетей
            $savedNetworks = $_POST['networks'] ?? [];
            $iniContent = "; Social Networks Configuration\n";
            $iniContent .= "; Auto-generated by Social Networks Plugin\n\n";
            $iniContent .= "[networks]\n\n";

            $order = 1;
            foreach ($savedNetworks as $id => $network) {
                // Получаем значения полей
                $networkId = trim($network['id'] ?? '');
                $networkName = trim($network['name'] ?? '');
                $networkUrl = trim($network['url'] ?? '');

                // Пропускаем полностью пустые записи
                if (empty($networkName) && empty($networkUrl) && empty($networkId)) {
                    continue;
                }

                // Пропускаем записи без названия или URL
                if (empty($networkName) || empty($networkUrl)) {
                    continue;
                }

                // Пропускаем записи с дефолтными значениями (не заполненные пользователем)
                $isDefaultName = (strtolower($networkName) === 'link');
                $isDefaultUrl = ($networkUrl === 'https://example.com');
                $isDefaultId = (preg_match('/^link\d+$/i', $networkId));

                // Если все поля имеют дефолтные значения - пропускаем
                if ($isDefaultName && $isDefaultUrl && ($isDefaultId || empty($networkId))) {
                    continue;
                }

                // Очищаем и валидируем ID
                if (empty($networkId)) {
                    $networkId = $id;
                }
                $networkId = preg_replace('/[^a-z0-9_-]/i', '', $networkId); // Очищаем ID
                if (empty($networkId)) {
                    $networkId = 'network_' . $order;
                }

                $iniContent .= "[networks.{$networkId}]\n";
                $iniContent .= "name = \"" . addslashes($network['name']) . "\"\n";
                $iniContent .= "url = \"" . addslashes($network['url']) . "\"\n";
                $iniContent .= "icon = \"" . addslashes($network['icon'] ?? 'fas fa-link') . "\"\n";
                $iniContent .= "order = " . (int)($network['order'] ?? $order) . "\n";
                $iniContent .= "enabled = " . (isset($network['enabled']) && $network['enabled'] ? '1' : '0') . "\n\n";
                $order++;
            }

            // Создаем директорию, если её нет
            $configDir = dirname($configFile);
            if (!is_dir($configDir)) {
                mkdir($configDir, 0755, true);
            }

            if (file_put_contents($configFile, $iniContent) !== false) {
                $message = 'Социальные сети успешно сохранены';
                $messageType = 'success';
            } else {
                $message = 'Ошибка при сохранении социальных сетей';
                $messageType = 'danger';
            }
        } elseif ($action === 'delete') {
            $networkId = $_POST['network_id'] ?? '';
            if (!empty($networkId)) {
                // Удаление конкретной сети (перезаписываем файл без неё)
                $currentNetworks = [];
                if (file_exists($configFile)) {
                    $config = parse_ini_file($configFile, true);
                    if (is_array($config)) {
                        // Обрабатываем формат [networks.id]
                        foreach ($config as $sectionName => $sectionData) {
                            if (is_array($sectionData) && strpos($sectionName, 'networks.') === 0) {
                                // Извлекаем ID из имени секции
                                $id = substr($sectionName, strlen('networks.'));
                                if ($id !== $networkId) {
                                    $currentNetworks[$id] = $sectionData;
                                }
                            } elseif ($sectionName === 'networks' && is_array($sectionData)) {
                                // Обрабатываем формат [networks] с подсекциями
                                foreach ($sectionData as $id => $networkData) {
                                    if ($id !== $networkId && is_array($networkData)) {
                                        $currentNetworks[$id] = $networkData;
                                    }
                                }
                            }
                        }
                    }
                }

                $iniContent = "; Social Networks Configuration\n";
                $iniContent .= "; Auto-generated by Social Networks Plugin\n\n";
                $iniContent .= "[networks]\n\n";

                $order = 1;
                foreach ($currentNetworks as $id => $network) {
                    $iniContent .= "[networks.{$id}]\n";
                    $iniContent .= "name = \"" . addslashes($network['name']) . "\"\n";
                    $iniContent .= "url = \"" . addslashes($network['url']) . "\"\n";
                    $iniContent .= "icon = \"" . addslashes($network['icon'] ?? 'fas fa-link') . "\"\n";
                    $iniContent .= "order = " . (int)($network['order'] ?? $order) . "\n";
                    $iniContent .= "enabled = " . (isset($network['enabled']) && $network['enabled'] ? '1' : '0') . "\n\n";
                    $order++;
                }

                $configDir = dirname($configFile);
                if (!is_dir($configDir)) {
                    mkdir($configDir, 0755, true);
                }

                file_put_contents($configFile, $iniContent);
                $message = 'Социальная сеть удалена';
                $messageType = 'success';
            }
        }
    }

    // Загружаем существующие социальные сети
    if (file_exists($configFile)) {
        $config = parse_ini_file($configFile, true);
        if (is_array($config)) {
            // Обрабатываем формат [networks.id]
            foreach ($config as $sectionName => $sectionData) {
                if (is_array($sectionData) && strpos($sectionName, 'networks.') === 0) {
                    // Извлекаем ID из имени секции (networks.id -> id)
                    $id = substr($sectionName, strlen('networks.'));
                    $networks[] = [
                        'id' => (string)$id,
                        'name' => $sectionData['name'] ?? $id,
                        'url' => $sectionData['url'] ?? '#',
                        'icon' => $sectionData['icon'] ?? 'fas fa-link',
                        'order' => (int)($sectionData['order'] ?? 999),
                        'enabled' => isset($sectionData['enabled']) ? (bool)(int)$sectionData['enabled'] : true,
                    ];
                } elseif ($sectionName === 'networks' && is_array($sectionData)) {
                    // Обрабатываем формат [networks] с подсекциями (если используется)
                    foreach ($sectionData as $id => $networkData) {
                        if (is_array($networkData)) {
                            $networks[] = [
                                'id' => (string)$id,
                                'name' => $networkData['name'] ?? $id,
                                'url' => $networkData['url'] ?? '#',
                                'icon' => $networkData['icon'] ?? 'fas fa-link',
                                'order' => (int)($networkData['order'] ?? 999),
                                'enabled' => isset($networkData['enabled']) ? (bool)(int)$networkData['enabled'] : true,
                            ];
                        }
                    }
                }
            }
        }
    }

    // Сортируем по order
    usort($networks, function ($a, $b) {
        return $a['order'] <=> $b['order'];
    });

    // Если нет сетей, добавляем одну пустую для формы
    if (empty($networks)) {
        $networks[] = [
            'id' => '',
            'name' => '',
            'url' => '',
            'icon' => 'fas fa-link',
            'order' => 1,
        ];
    }

    $content = '<div class="container-fluid">';

    if ($message) {
        $content .= '<div class="alert alert-' . htmlspecialchars($messageType, ENT_QUOTES, 'UTF-8') . ' alert-dismissible fade show" role="alert">
            ' . htmlspecialchars($message, ENT_QUOTES, 'UTF-8') . '
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>';
    }


    $content .= '<form id="socialNetworksForm" method="POST" action="' . admin_url('social-networks') . '">
        <input type="hidden" name="action" value="save">
        <div class="card">
            <div class="card-header">
                <div class="d-flex align-items-center justify-content-between">
                    <div>
                        <h5 class="mb-0">
                            <i class="fas fa-share-alt"></i> Список социальных сетей
                        </h5>
                        <small class="text-muted">Управление социальными сетями для отображения в футере сайта</small>
                    </div>
                </div>
            </div>
            <div class="card-body">
                <div id="networks-list">';

    foreach ($networks as $index => $network) {
        $networkId = htmlspecialchars($network['id'], ENT_QUOTES, 'UTF-8');
        $isEnabled = isset($network['enabled']) ? (bool)$network['enabled'] : true;
        $enabledClass = $isEnabled ? '' : 'network-disabled';

        $content .= '<div class="network-item mb-2 p-3 border rounded position-relative ' . $enabledClass . '" data-index="' . $index . '" data-network-id="' . $networkId . '">
            <div class="network-item-header d-flex justify-content-between align-items-center mb-2">
                <div class="d-flex align-items-center gap-2">
                    <div class="network-toggle-wrapper">
                        <label class="network-toggle" title="Включить/выключить">
                            <input type="checkbox" name="networks[' . $index . '][enabled]" value="1" ' . ($isEnabled ? 'checked' : '') . ' onchange="toggleNetwork(this)">
                            <span class="network-toggle-slider"></span>
                        </label>
                    </div>
                    <span class="network-status-badge ' . ($isEnabled ? 'badge-success' : 'badge-secondary') . '">
                        ' . ($isEnabled ? 'Включено' : 'Выключено') . '
                    </span>
                </div>
                <button type="button" class="btn btn-sm btn-outline-danger network-delete-btn" onclick="deleteNetwork(\'' . $networkId . '\')" title="Удалить">
                    <i class="fas fa-trash-alt"></i>
                </button>
            </div>
            <div class="row g-2">
                <div class="col-md-2">
                    <label class="form-label">
                        ID
                        <i class="fas fa-info-circle text-muted ms-1" data-bs-toggle="tooltip" data-bs-placement="top" title="Уникальный идентификатор (латиница)"></i>
                    </label>
                    <input type="text" class="form-control form-control-sm" name="networks[' . $index . '][id]" value="' . $networkId . '" placeholder="instagram">
                </div>
                <div class="col-md-2">
                    <label class="form-label">
                        Название
                        <i class="fas fa-info-circle text-muted ms-1" data-bs-toggle="tooltip" data-bs-placement="top" title="Отображаемое название"></i>
                    </label>
                    <input type="text" class="form-control form-control-sm" name="networks[' . $index . '][name]" value="' . htmlspecialchars($network['name'], ENT_QUOTES, 'UTF-8') . '" placeholder="Instagram">
                </div>
                <div class="col-md-4">
                    <label class="form-label">
                        URL
                        <i class="fas fa-info-circle text-muted ms-1" data-bs-toggle="tooltip" data-bs-placement="top" title="Ссылка на страницу"></i>
                    </label>
                    <input type="url" class="form-control form-control-sm" name="networks[' . $index . '][url]" value="' . htmlspecialchars($network['url'], ENT_QUOTES, 'UTF-8') . '" placeholder="https://www.instagram.com/yourpage">
                </div>
                <div class="col-md-2">
                    <label class="form-label">
                        Иконка
                        <i class="fas fa-info-circle text-muted ms-1" data-bs-toggle="tooltip" data-bs-placement="top" title="Font Awesome класс"></i>
                    </label>
                    <input type="text" class="form-control form-control-sm" name="networks[' . $index . '][icon]" value="' . htmlspecialchars($network['icon'], ENT_QUOTES, 'UTF-8') . '" placeholder="fab fa-instagram">
                </div>
                <div class="col-md-2">
                    <label class="form-label">
                        Порядок
                        <i class="fas fa-info-circle text-muted ms-1" data-bs-toggle="tooltip" data-bs-placement="top" title="Порядок отображения"></i>
                    </label>
                    <input type="number" class="form-control form-control-sm" name="networks[' . $index . '][order]" value="' . $network['order'] . '" min="1">
                </div>
            </div>
        </div>';
    }

    $content .= '    </div>
                <div class="mt-2">
                    <button type="button" class="btn btn-sm btn-outline-secondary" onclick="addNetwork()" title="Добавить новую социальную сеть">
                        <i class="fas fa-plus"></i> Добавить
                    </button>
                </div>
            </div>
        </div>
    </form>
    </div>

    <style>
    /* Плоский корпоративный стиль */
    .network-item {
        transition: all 0.2s ease;
        background: #ffffff;
        border: 1px solid #e0e0e0;
        border-radius: 4px;
    }
    .network-item:hover {
        border-color: #bdbdbd;
        box-shadow: 0 2px 4px rgba(0, 0, 0, 0.08);
    }
    .network-item.network-disabled {
        opacity: 0.6;
        background: #fafafa;
    }
    .network-item-header {
        background: transparent;
        border-bottom: none;
    }
    .network-toggle-wrapper {
        display: inline-block;
    }
    .network-toggle {
        position: relative;
        display: inline-block;
        width: 36px;
        height: 20px;
        margin: 0;
        cursor: pointer;
    }
    .network-toggle input {
        opacity: 0;
        width: 0;
        height: 0;
    }
    .network-toggle-slider {
        position: absolute;
        cursor: pointer;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background-color: #bdbdbd;
        transition: 0.2s;
        border-radius: 20px;
    }
    .network-toggle-slider:before {
        position: absolute;
        content: "";
        height: 14px;
        width: 14px;
        left: 3px;
        bottom: 3px;
        background-color: white;
        transition: 0.2s;
        border-radius: 50%;
        box-shadow: 0 1px 2px rgba(0, 0, 0, 0.15);
    }
    .network-toggle input:checked + .network-toggle-slider {
        background-color: #4CAF50;
    }
    .network-toggle input:checked + .network-toggle-slider:before {
        transform: translateX(16px);
    }
    .network-status-badge {
        display: inline-block;
        padding: 2px 8px;
        border-radius: 2px;
        font-size: 10px;
        font-weight: 600;
        text-transform: uppercase;
        letter-spacing: 0.2px;
        border: none;
        line-height: 1.4;
    }
    .network-status-badge.badge-success {
        background-color: #4CAF50;
        color: #ffffff;
    }
    .network-status-badge.badge-secondary {
        background-color: #9e9e9e;
        color: #ffffff;
    }
    .network-delete-btn {
        border-radius: 3px;
        padding: 5px 10px;
        font-size: 12px;
        font-weight: 500;
        transition: all 0.15s ease;
        border-width: 1px;
    }
    .network-delete-btn:hover {
        background-color: #dc3545;
        border-color: #dc3545;
        color: #fff;
    }
    .network-delete-btn i {
        font-size: 12px;
    }
    .form-label {
        font-size: 12px;
        margin-bottom: 4px;
        color: #424242;
        font-weight: 500;
    }
    .form-control, .form-control-sm {
        border-radius: 3px;
        border: 1px solid #e0e0e0;
        transition: all 0.15s ease;
        font-size: 13px;
        padding: 6px 10px;
    }
    .form-control:focus, .form-control-sm:focus {
        border-color: #4CAF50;
        box-shadow: 0 0 0 2px rgba(76, 175, 80, 0.1);
        outline: none;
    }
    .form-label i.fa-info-circle {
        cursor: help;
        opacity: 0.5;
        font-size: 11px;
    }
    .form-label i.fa-info-circle:hover {
        opacity: 0.8;
    }
    .card-header {
        background: #ffffff;
        border-bottom: 1px solid #e0e0e0;
        padding: 16px 20px;
    }
    .card-header h5 {
        font-size: 16px;
        font-weight: 600;
        color: #212121;
        margin: 0;
    }
    .card-header small {
        font-size: 12px;
        color: #757575;
        display: block;
        margin-top: 4px;
    }
    .card-body {
        padding: 16px 20px;
    }
    @media (max-width: 768px) {
        .network-item-header {
            flex-direction: column;
            align-items: flex-start !important;
            gap: 8px;
        }
        .network-delete-btn {
            align-self: flex-end;
        }
    }
    </style>

    <script>
    function toggleNetwork(checkbox) {
        const networkItem = checkbox.closest(".network-item");
        const isEnabled = checkbox.checked;
        const badge = networkItem.querySelector(".network-status-badge");

        if (isEnabled) {
            networkItem.classList.remove("network-disabled");
            badge.className = "network-status-badge badge-success";
            badge.innerHTML = "Включено";
        } else {
            networkItem.classList.add("network-disabled");
            badge.className = "network-status-badge badge-secondary";
            badge.innerHTML = "Выключено";
        }
    }
    </script>';

    // Создаем кнопки для header (настройки и сохранить)
    $saveButton = '<button type="submit" form="socialNetworksForm" class="btn btn-sm btn-primary d-flex align-items-center" title="Сохранить все изменения в социальных сетях">
        <i class="fas fa-save"></i>
        <span class="ms-1">Сохранить</span>
    </button>';

    $settingsButton = '<button type="button" class="btn btn-sm btn-outline-secondary d-flex align-items-center" data-bs-toggle="modal" data-bs-target="#socialNetworksSettingsModal" title="Открыть настройки плагина (статус, стиль, размер, цвет)">
        <i class="fas fa-cog"></i>
        <span class="ms-1">Настройки</span>
    </button>';

    $headerButtons = $settingsButton . ' ' . $saveButton;

    // Создаем модальное окно настроек
    $modalContent = '
    <form id="socialNetworksSettingsForm" method="POST" action="' . admin_url('social-networks') . '">
        <input type="hidden" name="action" value="save_settings">

        <div class="mb-3">
            <label class="form-label">Статус плагина</label>
            <select class="form-select" name="status" required>
                <option value="activated" ' . ($currentStatus === 'activated' ? 'selected' : '') . '>Активирован</option>
                <option value="deactivated" ' . ($currentStatus === 'deactivated' ? 'selected' : '') . '>Деактивирован</option>
            </select>
            <small class="form-text text-muted">Определяет, отображаются ли социальные сети в футере</small>
        </div>

    </form>';

    $modalFooter = '
    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Отмена</button>
    <button type="submit" form="socialNetworksSettingsForm" class="btn btn-primary">
        <i class="fas fa-save"></i> Сохранить настройки
    </button>';

    // Добавляем модальное окно в контент
    $content .= '
    <div class="modal fade" id="socialNetworksSettingsModal" tabindex="-1" aria-labelledby="socialNetworksSettingsModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="socialNetworksSettingsModalLabel">
                        <i class="fas fa-cog"></i> Настройки плагина "Социальные сети"
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Закрыть"></button>
                </div>
                <div class="modal-body">
                    ' . $modalContent . '
                </div>
                <div class="modal-footer">
                    ' . $modalFooter . '
                </div>
            </div>
        </div>
    </div>

    <script>
    function addNetwork() {
        const list = document.getElementById("networks-list");
        const index = list.children.length;
        const newItem = document.createElement("div");
        newItem.className = "network-item mb-2 p-3 border rounded position-relative network-disabled";
        newItem.setAttribute("data-index", index);
        newItem.setAttribute("data-network-id", "");
        newItem.innerHTML = `
            <div class="network-item-header d-flex justify-content-between align-items-center mb-2">
                <div class="d-flex align-items-center gap-2">
                    <div class="network-toggle-wrapper">
                        <label class="network-toggle" title="Включить/выключить">
                            <input type="checkbox" name="networks[${index}][enabled]" value="1" onchange="toggleNetwork(this)">
                            <span class="network-toggle-slider"></span>
                        </label>
                    </div>
                    <span class="network-status-badge badge-secondary">Выключено</span>
                </div>
                <button type="button" class="btn btn-sm btn-outline-danger network-delete-btn" onclick="deleteNetwork(\'\')" title="Удалить" disabled>
                    <i class="fas fa-trash-alt"></i>
                </button>
            </div>
            <div class="row g-2">
                <div class="col-md-2">
                    <label class="form-label">
                        ID
                        <i class="fas fa-info-circle text-muted ms-1" data-bs-toggle="tooltip" data-bs-placement="top" title="Уникальный идентификатор (латиница)"></i>
                    </label>
                    <input type="text" class="form-control form-control-sm" name="networks[${index}][id]" value="link${index + 1}">
                </div>
                <div class="col-md-2">
                    <label class="form-label">
                        Название
                        <i class="fas fa-info-circle text-muted ms-1" data-bs-toggle="tooltip" data-bs-placement="top" title="Отображаемое название"></i>
                    </label>
                    <input type="text" class="form-control form-control-sm" name="networks[${index}][name]" value="Link">
                </div>
                <div class="col-md-4">
                    <label class="form-label">
                        URL
                        <i class="fas fa-info-circle text-muted ms-1" data-bs-toggle="tooltip" data-bs-placement="top" title="Ссылка на страницу"></i>
                    </label>
                    <input type="url" class="form-control form-control-sm" name="networks[${index}][url]" value="https://example.com">
                </div>
                <div class="col-md-2">
                    <label class="form-label">
                        Иконка
                        <i class="fas fa-info-circle text-muted ms-1" data-bs-toggle="tooltip" data-bs-placement="top" title="Font Awesome класс"></i>
                    </label>
                    <input type="text" class="form-control form-control-sm" name="networks[${index}][icon]" value="fas fa-link">
                </div>
                <div class="col-md-2">
                    <label class="form-label">
                        Порядок
                        <i class="fas fa-info-circle text-muted ms-1" data-bs-toggle="tooltip" data-bs-placement="top" title="Порядок отображения"></i>
                    </label>
                    <input type="number" class="form-control form-control-sm" name="networks[${index}][order]" value="${index + 1}" min="1">
                </div>
            </div>
        `;
        list.appendChild(newItem);

        // Инициализируем tooltips для новых элементов
        if (typeof bootstrap !== "undefined" && bootstrap.Tooltip) {
            var tooltipTriggerList = [].slice.call(newItem.querySelectorAll(\'[data-bs-toggle="tooltip"]\'));
            tooltipTriggerList.forEach(function (tooltipTriggerEl) {
                new bootstrap.Tooltip(tooltipTriggerEl);
            });
        }
    }

    // Инициализация tooltips Bootstrap
    if (typeof bootstrap !== "undefined" && bootstrap.Tooltip) {
        var tooltipTriggerList = [].slice.call(document.querySelectorAll(\'[data-bs-toggle="tooltip"]\'));
        var tooltipList = tooltipTriggerList.map(function (tooltipTriggerEl) {
            return new bootstrap.Tooltip(tooltipTriggerEl);
        });
    }

    function deleteNetwork(networkId) {
        if (!networkId || networkId === "") {
            alert("Нельзя удалить запись без ID. Сохраните запись сначала.");
            return;
        }

        if (!confirm("Вы уверены, что хотите удалить эту социальную сеть? Это действие нельзя отменить.")) {
            return;
        }

        // Создаем форму для отправки запроса на удаление
        const form = document.createElement("form");
        form.method = "POST";
        form.action = "' . admin_url('social-networks') . '";

        const actionInput = document.createElement("input");
        actionInput.type = "hidden";
        actionInput.name = "action";
        actionInput.value = "delete";
        form.appendChild(actionInput);

        const networkIdInput = document.createElement("input");
        networkIdInput.type = "hidden";
        networkIdInput.name = "network_id";
        networkIdInput.value = networkId;
        form.appendChild(networkIdInput);

        document.body.appendChild(form);
        form.submit();
    }
    </script>';

    if (function_exists('render_admin_layout')) {
        return render_admin_layout([
            'title' => 'Социальные сети - Flowaxy CMS',
            'content' => $content,
            'pageHeaderIcon' => 'fas fa-share-alt',
            'pageHeaderButtons' => $headerButtons,
            'pageBreadcrumbs' => [
                ['title' => 'Головна', 'url' => admin_url('dashboard'), 'page' => 'dashboard'],
                ['title' => 'Социальные сети', 'page' => 'social-networks'],
            ],
        ]);
    }

    echo $content;
}
