<?php

/**
 * Страница управления слайдерами
 */

function admin_slider_manager_page()
{
    $title = 'Управление слайдерами';

    $content = '<div class="container-fluid">
        <h1 class="mb-4">Управление слайдерами</h1>
        <p class="text-muted mb-3">
            Здесь в будущем будет полноценный интерфейс управления слайдерами: добавление слайдов,
            привязка к страницам, настройка интервалов и стилей. Сейчас страница содержит только тестовый макет.
        </p>
        <div class="card mb-3">
            <div class="card-header">
                <i class="fas fa-sliders-h"></i> Активный слайдер темы</div>
            <div class="card-body">
                <p class="mb-0">Активная тема: <strong>default</strong>. Слайдер на главной странице управляется через компоненты темы.</p>
                <p class="mb-0 text-muted">Этот плагин в дальнейшем будет позволять создавать несколько слайдеров и привязывать их к разным страницам.</p>
            </div>
        </div>
        <div class="alert alert-info">
            <i class="fas fa-info-circle"></i> Тестовая страница плагина Slider Manager. Функционал конструкторов слайдов будет реализован позже.
        </div>
    </div>';

    if (function_exists('render_admin_layout')) {
        return render_admin_layout([
            'title' => $title,
            'content' => $content,
            'pageHeaderIcon' => 'fas fa-images',
            'pageBreadcrumbs' => [
                ['title' => 'Головна', 'url' => admin_url('dashboard'), 'page' => 'dashboard'],
                ['title' => 'Слайдеры', 'page' => 'slider-manager'],
            ],
        ]);
    }

    echo $content;
}
