<?php

/**
 * Slider Manager Plugin
 *
 * @name: Slider Manager
 * @slug: slider-manager
 * @version: 1.0.0
 * @description: Плагін для управління слайдерами теми (слайды, настройки, привязка к страницам)
 * @author: Flowaxy Team
 * @author_url: https://flowaxy.com
 * @requires: 1.0.0
 * @tested: 1.0.0
 * @package: SliderManager
 *
 * FLOWAXY CMS 1.0.0 Stable
 */

declare(strict_types=1);

use Flowaxy\Support\Base\BasePlugin;

final class SliderManagerPlugin extends BasePlugin
{
    public function registerHooks(): void
    {
        // Пункт меню "Слайдеры" в админке
        if (function_exists('add_filter')) {
            add_filter('admin_menu', function ($menu) {
                $menu[] = [
                    'text' => 'Слайдеры',
                    'title' => 'Управление слайдерами сайта',
                    'icon' => 'fas fa-images',
                    'href' => admin_url('slider-manager'),
                    'page' => 'slider-manager',
                    'permission' => 'admin.access',
                    'order' => 44,
                ];

                return $menu;
            });
        }
    }

    public function registerRoutes(): void
    {
        // Регистрируем страницу управления слайдерами через admin_routes
        $this->registerHook('admin_routes', function ($router) {
            $pageFile = __DIR__ . DS . 'admin' . DS . 'pages' . DS . 'slider-manager.php';
            if (file_exists($pageFile) && is_readable($pageFile)) {
                require_once $pageFile;
            }

            if ($router && method_exists($router, 'add')) {
                $router->add(['GET', 'POST'], 'slider-manager', 'admin_slider_manager_page', ['middleware' => ['admin.auth']]);
            }
        });
    }

    public function activate(): void
    {
        parent::activate();
    }

    public function deactivate(): void
    {
        parent::deactivate();
    }
}
