<?php

/**
 * Страница конструктора страниц (Page Builder)
 */

function admin_page_builder_page()
{
    $title = 'Конструктор сторінок';

    $content = '<div class="container-fluid">
        <h1 class="mb-4">Конструктор сторінок</h1>
        <p class="text-muted mb-3">
            Це тестова сторінка конструктора сторінок. Надалі тут можна буде створювати сторінки,
            додавати до них віджети та компоненти теми (аналог WordPress Page Builder).
        </p>
        <div class="card mb-3">
            <div class="card-header">
                <i class="fas fa-layer-group"></i> Швидкий старт</div>
            <div class="card-body">
                <ol class="mb-0">
                    <li>Створіть нову сторінку.</li>
                    <li>Додайте до неї блоки (секції) та віджети.</li>
                    <li>Прив’яжіть сторінку до меню навігації.</li>
                </ol>
            </div>
        </div>
        <div class="alert alert-info">
            <i class="fas fa-info-circle"></i> Функціонал конструктора (зберігання сторінок у БД, drag-and-drop, вибір віджетів)
            буде реалізовано в наступних ітераціях. Зараз це лише каркас плагіна.
        </div>
    </div>';

    if (function_exists('render_admin_layout')) {
        return render_admin_layout([
            'title' => $title,
            'content' => $content,
            'pageHeaderIcon' => 'fas fa-file-alt',
            'pageBreadcrumbs' => [
                ['title' => 'Головна', 'url' => admin_url('dashboard'), 'page' => 'dashboard'],
                ['title' => 'Конструктор сторінок', 'page' => 'page-builder'],
            ],
        ]);
    }

    echo $content;
}
