<?php

/**
 * Page Builder Plugin
 *
 * @name: Page Builder
 * @slug: page-builder
 * @version: 1.0.0
 * @description: Плагін-конструктор сторінок з використанням компонентів теми та віджетів
 * @author: Flowaxy Team
 * @author_url: https://flowaxy.com
 * @requires: 1.0.0
 * @tested: 1.0.0
 * @package: PageBuilder
 *
 * FLOWAXY CMS 1.0.0 Stable
 */

declare(strict_types=1);

use Flowaxy\Support\Base\BasePlugin;

final class PageBuilderPlugin extends BasePlugin
{
    public function registerHooks(): void
    {
        // Пункт меню "Конструктор сторінок" в админке
        if (function_exists('add_filter')) {
            add_filter('admin_menu', function ($menu) {
                $menu[] = [
                    'text' => 'Конструктор сторінок',
                    'title' => 'Конструктор сторінок (Page Builder)',
                    'icon' => 'fas fa-file-alt',
                    'href' => admin_url('page-builder'),
                    'page' => 'page-builder',
                    'permission' => 'admin.access',
                    'order' => 45,
                ];

                return $menu;
            });
        }
    }

    public function registerRoutes(): void
    {
        // Регистрируем страницу конструктора страниц через admin_routes
        $this->registerHook('admin_routes', function ($router) {
            $pageFile = __DIR__ . DS . 'admin' . DS . 'pages' . DS . 'page-builder.php';
            if (file_exists($pageFile) && is_readable($pageFile)) {
                require_once $pageFile;
            }

            if ($router && method_exists($router, 'add')) {
                $router->add(['GET', 'POST'], 'page-builder', 'admin_page_builder_page', ['middleware' => ['admin.auth']]);
            }
        });
    }

    public function activate(): void
    {
        parent::activate();
    }

    public function deactivate(): void
    {
        parent::deactivate();
    }
}
