/**
 * Flowaxy Admin Panel - Profile Page JavaScript
 * Управление профилем пользователя: показ/скрытие паролей, валидация формы
 */

(function() {
    'use strict';

    document.addEventListener('DOMContentLoaded', function() {
        initPasswordToggle();
        initFormValidation();
    });

    /**
     * Инициализация переключения видимости паролей
     */
    function initPasswordToggle() {
        const showPasswordsCheckbox = document.getElementById('showPasswords');
        if (!showPasswordsCheckbox) {
            return;
        }

        showPasswordsCheckbox.addEventListener('change', function() {
            const type = this.checked ? 'text' : 'password';
            const currentPassword = document.getElementById('current_password');
            const newPassword = document.getElementById('new_password');
            const confirmPassword = document.getElementById('confirm_password');

            if (currentPassword) {
                currentPassword.type = type;
            }
            if (newPassword) {
                newPassword.type = type;
            }
            if (confirmPassword) {
                confirmPassword.type = type;
            }
        });
    }

    /**
     * Инициализация валидации формы
     */
    function initFormValidation() {
        const profileForm = document.getElementById('profileForm');
        if (!profileForm) {
            return;
        }

        profileForm.addEventListener('submit', function(e) {
            const newPassword = document.getElementById('new_password');
            const confirmPassword = document.getElementById('confirm_password');
            const currentPassword = document.getElementById('current_password');
            const minLength = parseInt(profileForm.getAttribute('data-min-length') || '8', 10);

            // Если введен новый пароль, проверяем остальные поля
            if ((newPassword && newPassword.value) || (confirmPassword && confirmPassword.value) || (currentPassword && currentPassword.value)) {
                if (!currentPassword || !currentPassword.value) {
                    e.preventDefault();
                    alert('Для зміни пароля необхідно ввести поточний пароль');
                    return false;
                }

                if (!newPassword || !newPassword.value) {
                    e.preventDefault();
                    alert('Введіть новий пароль');
                    return false;
                }

                if (newPassword.value.length < minLength) {
                    e.preventDefault();
                    alert('Пароль повинен містити мінімум ' + minLength + ' символів');
                    return false;
                }

                if (newPassword.value !== confirmPassword.value) {
                    e.preventDefault();
                    alert('Нові паролі не співпадають');
                    return false;
                }
            }
        });
    }

    /**
     * Сброс формы
     */
    window.resetForm = function() {
        const profileForm = document.getElementById('profileForm');
        if (!profileForm) {
            return;
        }

        if (confirm('Ви впевнені, що хочете скинути всі зміни?')) {
            profileForm.reset();
            const currentPassword = document.getElementById('current_password');
            const newPassword = document.getElementById('new_password');
            const confirmPassword = document.getElementById('confirm_password');
            const showPasswords = document.getElementById('showPasswords');

            if (currentPassword) {
                currentPassword.value = '';
            }
            if (newPassword) {
                newPassword.value = '';
            }
            if (confirmPassword) {
                confirmPassword.value = '';
            }
            if (showPasswords) {
                showPasswords.checked = false;
            }
        }
    };
})();
