/**
 * Flowaxy Admin Panel - Plugins Page JavaScript
 * Управление плагинами: активация, деактивация, установка, удаление
 */

(function() {
    'use strict';

    // Получаем CSRF токен из PHP (должен быть передан через data-атрибут или скрытое поле)
    function getCsrfToken() {
        const tokenInput = document.querySelector('input[name="csrf_token"]');
        if (tokenInput) {
            return tokenInput.value;
        }
        return '';
    }

    window.togglePlugin = function(slug, activate) {
        const action = activate ? 'activate' : 'deactivate';
        const form = document.createElement('form');
        form.method = 'POST';
        form.innerHTML = `
            <input type="hidden" name="csrf_token" value="${getCsrfToken()}">
            <input type="hidden" name="action" value="${action}">
            <input type="hidden" name="plugin_slug" value="${slug}">
        `;
        document.body.appendChild(form);
        form.submit();
    };

    window.installPlugin = function(slug) {
        if (confirm('Встановити цей плагін?')) {
            const form = document.createElement('form');
            form.method = 'POST';
            form.innerHTML = `
                <input type="hidden" name="csrf_token" value="${getCsrfToken()}">
                <input type="hidden" name="action" value="install">
                <input type="hidden" name="plugin_slug" value="${slug}">
            `;
            document.body.appendChild(form);
            form.submit();
        }
    };

    window.uninstallPlugin = function(slug) {
        if (confirm('Ви впевнені, що хочете видалити цей плагін? Всі дані плагіна будуть втрачені.')) {
            const form = document.createElement('form');
            form.method = 'POST';
            form.innerHTML = `
                <input type="hidden" name="csrf_token" value="${getCsrfToken()}">
                <input type="hidden" name="action" value="uninstall">
                <input type="hidden" name="plugin_slug" value="${slug}">
            `;
            document.body.appendChild(form);
            form.submit();
        }
    };
})();
