/**
 * Flowaxy Admin Panel - Notifications Initialization
 * Инициализация уведомлений из PHP переменных
 */

(function() {
    'use strict';

    /**
     * Показывает уведомление из data-атрибутов
     */
    function initNotificationFromData() {
        const notificationElement = document.getElementById('notification-data');
        if (!notificationElement) {
            return;
        }

        let message = notificationElement.getAttribute('data-message');
        const type = notificationElement.getAttribute('data-type') || 'info';

        if (!message) {
            return;
        }

        // Пытаемся распарсить JSON, если это JSON-строка
        if (message.startsWith('"') || message.startsWith('{') || message.startsWith('[')) {
            try {
                message = JSON.parse(message);
            } catch (e) {
                // Если не JSON, оставляем как есть
                console.warn('Failed to parse notification message as JSON:', e);
            }
        }

        // Убеждаемся, что message не пустой
        if (message && message.trim() !== '') {
            // Небольшая задержка для гарантии, что DOM готов
            setTimeout(function() {
                if (typeof window.showNotification !== 'undefined') {
                    window.showNotification(message, type);
                } else if (typeof window.Notifications !== 'undefined' && typeof window.Notifications.show === 'function') {
                    window.Notifications.show(message, type);
                } else {
                    // Fallback: используем стандартный alert
                    alert(message);
                }
            }, 100);
        }
    }

    // Инициализация при загрузке DOM
    if (document.readyState === 'loading') {
        document.addEventListener('DOMContentLoaded', initNotificationFromData);
    } else {
        initNotificationFromData();
    }
})();
